/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.projection.impl;

import java.util.List;
import java.util.Vector;
import org.scribble.common.logging.Journal;
import org.scribble.protocol.model.Activity;
import org.scribble.protocol.model.Block;
import org.scribble.protocol.model.Choice;
import org.scribble.protocol.model.DefaultVisitor;
import org.scribble.protocol.model.Include;
import org.scribble.protocol.model.Interaction;
import org.scribble.protocol.model.Introduces;
import org.scribble.protocol.model.ModelObject;
import org.scribble.protocol.model.ParameterDefinition;
import org.scribble.protocol.model.Protocol;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.model.Run;
import org.scribble.protocol.model.Visitor;
import org.scribble.protocol.projection.impl.ProjectorContext;
import org.scribble.protocol.projection.impl.ProjectorRule;

public class ProtocolProjectorRule
implements ProjectorRule {
    public boolean isSupported(ModelObject obj) {
        return obj.getClass() == Protocol.class;
    }

    public ModelObject project(ProjectorContext context, ModelObject model, Role role, Journal l) {
        Protocol ret = null;
        Protocol source = (Protocol)model;
        List<Role> roles = null;
        if (context.isOuterScope() || (roles = context.getRolesOfInterestForDefinition(source)) != null) {
            if (roles == null) {
                roles = new Vector<Role>();
                roles.add(role);
            }
            for (int j = 0; j < roles.size(); ++j) {
                Protocol prot = new Protocol();
                role = roles.get(j);
                prot.derivedFrom((ModelObject)source);
                prot.setName(source.getName());
                Role located = (Role)context.project((ModelObject)role, role, l);
                prot.setRole(located);
                context.pushScope();
                for (ParameterDefinition p : source.getParameterDefinitions()) {
                    ParameterDefinition projp = (ParameterDefinition)context.project((ModelObject)p, role, l);
                    if (projp == null) continue;
                    prot.getParameterDefinitions().add(projp);
                }
                prot.setBlock((Block)context.project((ModelObject)source.getBlock(), role, l));
                prot.getBlock().setParent((ModelObject)prot);
                context.popScope();
                this.cleanUpRoles(prot);
                if (ret == null) {
                    ret = prot;
                    continue;
                }
                if (ret instanceof Block) {
                    ((Block)ret).getContents().add(prot);
                    continue;
                }
                Block b = new Block();
                b.getContents().add(ret);
                b.getContents().add(prot);
                ret = b;
            }
        }
        return ret;
    }

    protected void cleanUpRoles(Protocol protocol) {
        protocol.visit((Visitor)new DefaultVisitor(){

            public void accept(Introduces list) {
                Block parent = (Block)list.getParent();
                for (int i = list.getRoles().size() - 1; i >= 0; --i) {
                    final Role role = (Role)list.getRoles().get(i);
                    final Vector acts = new Vector();
                    parent.visit((Visitor)new DefaultVisitor(){

                        public void accept(Interaction interaction) {
                            if (role.equals((Object)interaction.getFromRole()) || interaction.getToRoles().contains(role)) {
                                acts.add(interaction);
                            }
                        }

                        public boolean start(Choice choice) {
                            if (role.equals((Object)choice.getRole())) {
                                acts.add(choice);
                            }
                            return true;
                        }

                        public void accept(Run run) {
                            if (run.getParameter(role.getName()) != null) {
                                acts.add(run);
                            }
                        }

                        public void accept(Include elem) {
                            if (elem.getParameter(role.getName()) != null) {
                                acts.add(elem);
                            }
                        }
                    });
                    if (acts.size() != 0) continue;
                    list.getRoles().remove(role);
                    if (list.getRoles().size() != 0) continue;
                    parent.remove((Activity)list);
                }
            }
        });
    }
}

