/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.projection.impl;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scope {
    private static Logger logger = Logger.getLogger("org.scribble.parser");
    private String m_locatedRole = null;
    private List<Map<String, Object>> m_stateStack = new Vector<Map<String, Object>>();
    private Map<String, Object> m_properties = new HashMap<String, Object>();

    public Scope() {
        this.pushState();
    }

    public Scope(Scope copy) {
        this.m_locatedRole = copy.m_locatedRole;
        for (int i = 0; i < copy.m_stateStack.size(); ++i) {
            Map<String, Object> current = copy.m_stateStack.get(i);
            Hashtable<String, Object> copyStackEntry = new Hashtable<String, Object>();
            for (String key : current.keySet()) {
                Object value = current.get(key);
                copyStackEntry.put(key, value);
            }
            this.m_stateStack.add(copyStackEntry);
        }
    }

    public Object getState(String name) {
        Object ret = null;
        if (this.m_stateStack.size() > 0) {
            for (int i = 0; ret == null && i < this.m_stateStack.size(); ++i) {
                Map<String, Object> current = this.m_stateStack.get(i);
                ret = current.get(name);
            }
        }
        return ret;
    }

    public void setState(String name, Object value) {
        if (this.m_stateStack.size() > 0) {
            Map<String, Object> current = this.m_stateStack.get(0);
            current.put(name, value);
        }
    }

    public String getLocatedParticipant() {
        return this.m_locatedRole;
    }

    public void setLocatedParticipant(String located) {
        this.m_locatedRole = located;
    }

    public void pushState() {
        this.m_stateStack.add(0, new Hashtable());
    }

    public void popState() {
        if (this.m_stateStack.size() > 0) {
            this.m_stateStack.remove(0);
        } else {
            logger.severe("No state entry to pop from stack");
        }
    }

    public Map<String, Object> getProperties() {
        return this.m_properties;
    }
}

