/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.projection.impl;

import java.util.List;
import org.scribble.common.logging.Journal;
import org.scribble.protocol.model.Include;
import org.scribble.protocol.model.ModelObject;
import org.scribble.protocol.model.Parameter;
import org.scribble.protocol.model.ParameterDefinition;
import org.scribble.protocol.model.Protocol;
import org.scribble.protocol.model.ProtocolImport;
import org.scribble.protocol.model.ProtocolModel;
import org.scribble.protocol.model.ProtocolReference;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.projection.impl.ProjectorContext;
import org.scribble.protocol.projection.impl.ProjectorRule;
import org.scribble.protocol.util.ProtocolModelUtil;

public class UseProjectorRule
implements ProjectorRule {
    public boolean isSupported(ModelObject obj) {
        return obj.getClass() == Include.class;
    }

    public ModelObject project(ProjectorContext context, ModelObject model, Role role, Journal l) {
        Include ret = new Include();
        Include source = (Include)model;
        ret.derivedFrom((ModelObject)source);
        List params = source.getParameters();
        int mappedIndex = -1;
        for (int i = 0; i < params.size(); ++i) {
            Parameter db = (Parameter)params.get(i);
            if (!db.getName().equals(role.getName())) {
                Parameter dbcopy = new Parameter(db.getName());
                dbcopy.derivedFrom((ModelObject)db);
                ret.getParameters().add(dbcopy);
                continue;
            }
            mappedIndex = i;
        }
        if (source.getReference() != null) {
            Protocol defn = null;
            ProtocolImport pi = ProtocolModelUtil.getProtocolImport((ProtocolModel)source.getModel(), (ProtocolReference)source.getReference());
            if (pi == null) {
                l.error("Referenced protocol '" + source.getReference().getName() + "' not found within model or in import statements", source.getProperties());
            } else {
                ProtocolModel pm = context.getProtocolContext().getProtocolModel(pi, l);
                if (pm != null) {
                    defn = pm.getProtocol();
                } else {
                    l.error("Referenced protocol '" + source.getReference().getName() + "' could not be loaded from location '" + pi.getLocation() + "'", source.getProperties());
                }
            }
            if (defn != null && mappedIndex != -1) {
                Role mappedRole = null;
                if (mappedIndex < defn.getParameterDefinitions().size()) {
                    ParameterDefinition pd = (ParameterDefinition)defn.getParameterDefinitions().get(mappedIndex);
                    if (pd.getType() != null) {
                        l.error("Include parameter is not a role", source.getProperties());
                    } else {
                        mappedRole = new Role(pd.getName());
                    }
                } else {
                    l.error("Include parameter is not a role", source.getProperties());
                }
                if (mappedRole != null) {
                    ret.setReference((ProtocolReference)context.project((ModelObject)source.getReference(), mappedRole, l));
                }
            } else {
                ret = null;
            }
        }
        return ret;
    }
}

