/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.export.text;

import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.PropertyResourceBundle;
import org.scribble.common.logging.Journal;
import org.scribble.protocol.export.ProtocolExporter;
import org.scribble.protocol.model.Block;
import org.scribble.protocol.model.Catch;
import org.scribble.protocol.model.Choice;
import org.scribble.protocol.model.DefaultVisitor;
import org.scribble.protocol.model.ImportList;
import org.scribble.protocol.model.Interaction;
import org.scribble.protocol.model.MessageSignature;
import org.scribble.protocol.model.Optional;
import org.scribble.protocol.model.Parallel;
import org.scribble.protocol.model.Protocol;
import org.scribble.protocol.model.ProtocolImport;
import org.scribble.protocol.model.ProtocolModel;
import org.scribble.protocol.model.RecBlock;
import org.scribble.protocol.model.Recursion;
import org.scribble.protocol.model.Repeat;
import org.scribble.protocol.model.RoleList;
import org.scribble.protocol.model.Run;
import org.scribble.protocol.model.Try;
import org.scribble.protocol.model.TypeImport;
import org.scribble.protocol.model.Unordered;
import org.scribble.protocol.model.When;

public class TextProtocolExporter
implements ProtocolExporter {
    public static final String TEXT_ID = "txt";

    public String getId() {
        return TEXT_ID;
    }

    public String getName() {
        return "Text";
    }

    public void export(ProtocolModel model, Journal journal, OutputStream os) {
        TextExportVisitor visitor = new TextExportVisitor(os);
        model.visit(visitor);
        if (visitor.getException() != null) {
            journal.error(MessageFormat.format(PropertyResourceBundle.getBundle("org.scribble.protocol.Messages").getString("_EXPORT_FAILED"), visitor.getException().getLocalizedMessage()), null);
        }
    }

    public static class TextExportVisitor
    extends DefaultVisitor {
        private OutputStream m_outputStream = null;
        private int m_indent = 0;
        private Exception m_exception = null;

        public TextExportVisitor(OutputStream os) {
            this.m_outputStream = os;
        }

        public boolean start(Block elem) {
            if (!(elem.getParent() instanceof When)) {
                if (elem.getParent() instanceof Parallel && ((Parallel)elem.getParent()).getBlocks().indexOf(elem) > 0) {
                    this.output(" and");
                }
                this.output(" {\r\n");
                ++this.m_indent;
            }
            return true;
        }

        public void end(Block elem) {
            if (!(elem.getParent() instanceof When)) {
                --this.m_indent;
                this.indent();
                this.output("}");
                if (this.isEndOfBlock(elem)) {
                    this.output("\r\n");
                }
            }
        }

        protected boolean isEndOfBlock(Block elem) {
            boolean ret = true;
            if (elem.getParent() instanceof Parallel) {
                ret = ((Parallel)elem.getParent()).getBlocks().indexOf(elem) == ((Parallel)elem.getParent()).getBlocks().size() - 1;
            } else if (elem.getParent() instanceof Catch) {
                Catch c = (Catch)elem.getParent();
                if (c.getParent() instanceof Try) {
                    Try te = (Try)c.getParent();
                    ret = te.getCatches().indexOf(c) == te.getCatches().size() - 1;
                }
            } else if (elem.getParent() instanceof Try) {
                ret = ((Try)elem.getParent()).getCatches().size() == 0;
            }
            return ret;
        }

        public void accept(ImportList elem) {
            this.output("import ");
            if (elem.getTypeImports().size() > 0) {
                boolean f_first = true;
                if (elem.getFormat() != null) {
                    this.output(elem.getFormat() + " ");
                }
                for (TypeImport t : elem.getTypeImports()) {
                    if (!f_first) {
                        this.output(", ");
                    }
                    f_first = false;
                    if (t.getDataType() != null && t.getDataType().getDetails() != null) {
                        this.output("\"" + t.getDataType().getDetails() + "\" as ");
                    }
                    this.output(t.getName());
                }
                if (elem.getLocation() != null) {
                    this.output("from \"" + elem.getLocation() + "\"");
                }
            } else {
                this.output("protocol ");
                boolean f_first = true;
                for (ProtocolImport t : elem.getProtocolImports()) {
                    if (!f_first) {
                        this.output(", ");
                    }
                    f_first = false;
                    this.output(t.getName());
                }
            }
            this.output(";\r\n");
        }

        public void accept(RoleList elem) {
            this.indent();
            this.output("role ");
            for (int i = 0; i < elem.getRoles().size(); ++i) {
                if (i > 0) {
                    this.output(", ");
                }
                this.output(elem.getRoles().get(i).getName());
            }
            this.output(";\r\n");
        }

        public void accept(Interaction elem) {
            if (!(elem.getParent() instanceof Catch)) {
                this.indent();
                this.outputInteraction(elem);
                this.output(";\r\n");
            }
        }

        protected void outputInteraction(Interaction elem) {
            this.outputMessageSignature(elem.getMessageSignature());
            if (elem.getFromRole() != null) {
                this.output(" from " + elem.getFromRole().getName());
            }
            if (elem.getToRoles().size() > 0) {
                this.output(" to ");
                for (int i = 0; i < elem.getToRoles().size(); ++i) {
                    if (i > 0) {
                        this.output(",");
                    }
                    this.output(elem.getToRoles().get(i).getName());
                }
            }
        }

        public void accept(Recursion elem) {
            this.indent();
            if (elem.getLabel() != null) {
                this.output(elem.getLabel());
            }
            this.output(";\r\n");
        }

        public boolean start(Protocol elem) {
            this.indent();
            this.output("protocol " + elem.getName());
            if (elem.getRole() != null) {
                this.output(" @ " + elem.getRole().getName());
            }
            return true;
        }

        public boolean start(Choice elem) {
            this.indent();
            this.output("choice");
            if (elem.getFromRole() != null) {
                this.output(" from " + elem.getFromRole().getName());
            }
            if (elem.getToRole() != null) {
                this.output(" to " + elem.getToRole().getName());
            }
            this.output(" {\r\n");
            ++this.m_indent;
            return true;
        }

        public void end(Choice elem) {
            --this.m_indent;
            this.indent();
            this.output("}\r\n");
        }

        public boolean start(When elem) {
            this.indent();
            this.outputMessageSignature(elem.getMessageSignature());
            this.output(":\r\n");
            ++this.m_indent;
            return true;
        }

        public void end(When elem) {
            this.output("\r\n");
            --this.m_indent;
        }

        public boolean start(Catch elem) {
            this.indent();
            this.output(" catch (");
            for (int i = 0; i < elem.getInteractions().size(); ++i) {
                if (i > 0) {
                    this.output(" | ");
                }
                this.outputInteraction(elem.getInteractions().get(i));
            }
            this.output(")");
            return true;
        }

        private void outputMessageSignature(MessageSignature ms) {
            if (ms != null) {
                if (ms.getOperation() != null) {
                    this.output(ms.getOperation() + "(");
                    for (int i = 0; i < ms.getTypeReferences().size(); ++i) {
                        if (i > 0) {
                            this.output(", ");
                        }
                        this.output(ms.getTypeReferences().get(i).getName());
                    }
                    this.output(")");
                } else if (ms.getTypeReferences().size() > 0) {
                    this.output(ms.getTypeReferences().get(0).getName());
                }
            }
        }

        public boolean start(Run elem) {
            this.indent();
            this.output("run " + elem.getProtocolReference().getName());
            if (elem.getProtocolReference().getRole() != null) {
                this.output("@" + elem.getProtocolReference().getRole().getName());
            }
            if (elem.getParameters().size() > 0) {
                this.output("(");
                for (int i = 0; i < elem.getParameters().size(); ++i) {
                    if (i > 0) {
                        this.output(", ");
                    }
                    this.output(elem.getParameters().get(i).getBoundName() + ":=" + elem.getParameters().get(i).getName());
                }
                this.output(")");
            }
            this.output(";\r\n");
            return true;
        }

        public boolean start(Parallel elem) {
            this.indent();
            this.output("par");
            return true;
        }

        public void end(Parallel elem) {
        }

        public boolean start(Try elem) {
            this.indent();
            this.output("try");
            return true;
        }

        public void end(Try elem) {
        }

        public boolean start(Repeat elem) {
            this.indent();
            this.output("repeat");
            if (elem.getRoles().size() > 0) {
                this.output(" @ ");
                for (int i = 0; i < elem.getRoles().size(); ++i) {
                    if (i > 0) {
                        this.output(",");
                    }
                    this.output(elem.getRoles().get(i).getName());
                }
            }
            return true;
        }

        public void end(Repeat elem) {
        }

        public boolean start(Unordered elem) {
            this.indent();
            this.output("unordered");
            return true;
        }

        public void end(Unordered elem) {
        }

        public boolean start(RecBlock elem) {
            this.indent();
            if (elem.getLabel() != null) {
                this.output("rec " + elem.getLabel());
            }
            return true;
        }

        public void end(RecBlock elem) {
        }

        public boolean start(Optional elem) {
            this.indent();
            this.output("optional");
            if (elem.getRoles().size() > 0) {
                this.output(" @ ");
                for (int i = 0; i < elem.getRoles().size(); ++i) {
                    if (i > 0) {
                        this.output(",");
                    }
                    this.output(elem.getRoles().get(i).getName());
                }
            }
            return true;
        }

        public void end(Optional elem) {
        }

        private void indent() {
            for (int i = 0; i < this.m_indent; ++i) {
                this.output("\t");
            }
        }

        private void output(String str) {
            try {
                this.m_outputStream.write(str.getBytes());
            }
            catch (Exception e) {
                this.m_exception = e;
            }
        }

        public Exception getException() {
            return this.m_exception;
        }
    }
}

