/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.model;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.scribble.protocol.model.Behaviour;
import org.scribble.protocol.model.Block;
import org.scribble.protocol.model.Parameter;
import org.scribble.protocol.model.Protocol;
import org.scribble.protocol.model.ProtocolReference;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.model.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Run
extends Behaviour {
    private static final long serialVersionUID = 7877693795925137333L;
    private ProtocolReference m_reference = null;
    private List<Parameter> m_parameters = new Vector<Parameter>();
    private Block m_block = null;

    public boolean isAsynchronous() {
        return false;
    }

    public List<Parameter> getParameters() {
        return this.m_parameters;
    }

    public Parameter getParameter(String declName) {
        Parameter ret = null;
        Iterator<Parameter> iter = this.getParameters().iterator();
        while (ret == null && iter.hasNext()) {
            ret = iter.next();
            if (ret.getName().equals(declName)) continue;
            ret = null;
        }
        return ret;
    }

    @Override
    public List<Role> initiatorRoles() {
        List<Role> ret = super.initiatorRoles();
        Protocol defn = this.getProtocol();
        if (defn != null) {
            ret.addAll(defn.getBlock().initiatorRoles());
        }
        return ret;
    }

    @Override
    public List<Role> finalRoles() {
        List<Role> ret = null;
        if (this.isAsynchronous()) {
            ret = this.initiatorRoles();
        } else {
            ret = super.finalRoles();
            Protocol defn = this.getProtocol();
            if (defn != null) {
                ret.addAll(defn.getBlock().finalRoles());
            }
        }
        return ret;
    }

    public ProtocolReference getProtocolReference() {
        return this.m_reference;
    }

    public void setProtocolReference(ProtocolReference ref) {
        if (this.m_reference != null) {
            this.m_reference.setParent(null);
        }
        this.m_reference = ref;
        if (this.m_reference != null) {
            this.m_reference.setParent(this);
        }
    }

    public Protocol getProtocol() {
        Protocol parent;
        Protocol ret = null;
        if (ret == null && (parent = this.enclosingProtocol()) != null) {
            for (int i = 0; ret == null && i < parent.getBlock().getContents().size(); ++i) {
                if (!(parent.getBlock().getContents().get(i) instanceof Protocol)) continue;
                Protocol inner = (Protocol)parent.getBlock().getContents().get(i);
                if (!this.m_reference.getName().equals(inner.getName())) continue;
                ret = inner;
            }
        }
        return ret;
    }

    public Block getBlock() {
        if (this.m_block == null) {
            this.m_block = new Block();
            this.m_block.setParent(this);
        }
        return this.m_block;
    }

    public void setBlock(Block block) {
        if (this.m_block != null) {
            this.m_block.setParent(null);
        }
        this.m_block = block;
        if (this.m_block != null) {
            this.m_block.setParent(this);
        }
    }

    public boolean isInline() {
        return this.m_reference == null || this.m_reference.getName() == null || this.m_reference.getName().trim().length() == 0;
    }

    @Override
    public void visit(Visitor visitor) {
        visitor.start(this);
        if (this.m_reference != null) {
            this.m_reference.visit(visitor);
        }
        for (Parameter db : this.getParameters()) {
            db.visit(visitor);
        }
        if (this.m_block != null && this.isInline()) {
            this.m_block.visit(visitor);
        }
        visitor.end(this);
    }
}

