/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.scribble.protocol.model.Block;
import org.scribble.protocol.model.Choice;
import org.scribble.protocol.model.DefaultVisitor;
import org.scribble.protocol.model.Interaction;
import org.scribble.protocol.model.MessageSignature;
import org.scribble.protocol.model.ModelObject;
import org.scribble.protocol.model.Protocol;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.model.Run;
import org.scribble.protocol.model.When;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InteractionUtil {
    public static Role getFromRole(ModelObject act) {
        Role ret = null;
        if (act instanceof Interaction) {
            ret = ((Interaction)act).getFromRole();
        } else if (act instanceof When && act.getParent() instanceof Choice) {
            ret = ((Choice)act.getParent()).getFromRole();
        } else if (act instanceof Choice) {
            ret = ((Choice)act).getFromRole();
        }
        return ret;
    }

    public static Role getToRole(ModelObject act) {
        Role ret = null;
        if (act instanceof Interaction) {
            if (((Interaction)act).getToRoles().size() > 0) {
                ret = ((Interaction)act).getToRoles().get(0);
            }
        } else if (act instanceof When && act.getParent() instanceof Choice) {
            ret = ((Choice)act.getParent()).getToRole();
        } else if (act instanceof Choice) {
            ret = ((Choice)act).getToRole();
        }
        return ret;
    }

    public static MessageSignature getMessageSignature(ModelObject act) {
        MessageSignature ret = null;
        if (act instanceof Interaction) {
            ret = ((Interaction)act).getMessageSignature();
        } else if (act instanceof When) {
            ret = ((When)act).getMessageSignature();
        }
        return ret;
    }

    public static List<ModelObject> getInitialInteractions(ModelObject model) {
        Vector<ModelObject> ret = new Vector<ModelObject>();
        model.visit(new InitialInteractionVisitor(ret));
        return ret;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InitialInteractionVisitor
    extends DefaultVisitor {
        private List<ModelObject> m_interactions = null;
        private boolean m_record = true;
        private Map<ModelObject, Boolean> m_savedState = new HashMap<ModelObject, Boolean>();

        public InitialInteractionVisitor(List<ModelObject> list) {
            this.m_interactions = list;
        }

        @Override
        public boolean start(Protocol elem) {
            return !(elem.getParent() instanceof Protocol);
        }

        @Override
        public boolean start(Block elem) {
            return true;
        }

        @Override
        public void end(Block elem) {
            if (elem.getParent() instanceof When) {
                this.m_record = this.m_savedState.get(elem.getParent());
            }
        }

        @Override
        public boolean start(When elem) {
            this.m_savedState.put(elem, this.m_record);
            Choice choice = (Choice)elem.getParent();
            if (this.m_record && (choice.getFromRole() == null || choice.getToRole() == null)) {
                this.m_interactions.add(elem);
                this.m_record = false;
            }
            return true;
        }

        @Override
        public void accept(Interaction elem) {
            if (this.m_record) {
                this.m_interactions.add(elem);
                this.m_record = false;
            }
        }

        public void accept(Run elem) {
            Protocol protocol = elem.getProtocol();
            if (protocol != null) {
                protocol.visit(this);
            }
        }
    }
}

