/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.scribble.common.model.Annotation;
import org.scribble.protocol.model.ProtocolModel;
import org.scribble.protocol.model.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModelObject {
    private ModelObject m_parent = null;
    private List<Annotation> m_annotations = new Vector<Annotation>();
    private Map<String, Object> m_properties = new HashMap<String, Object>();

    public ModelObject() {
    }

    public ModelObject(ModelObject obj) {
        this.m_properties.putAll(obj.getProperties());
    }

    public ModelObject getParent() {
        return this.m_parent;
    }

    public void setParent(ModelObject parent) {
        this.m_parent = parent;
    }

    public void derivedFrom(ModelObject modelObj) {
        if (modelObj != null) {
            this.m_properties = new HashMap<String, Object>(modelObj.getProperties());
            this.m_annotations = new Vector<Annotation>(modelObj.getAnnotations());
        }
    }

    public List<Annotation> getAnnotations() {
        return this.m_annotations;
    }

    public Map<String, Object> getProperties() {
        return this.m_properties;
    }

    public ProtocolModel getModel() {
        ProtocolModel ret = null;
        ModelObject cur = this;
        while (ret == null && cur != null) {
            if (cur instanceof ProtocolModel) {
                ret = (ProtocolModel)cur;
                continue;
            }
            cur = cur.getParent();
        }
        return ret;
    }

    public abstract void visit(Visitor var1);
}

