/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.model;

import java.util.List;
import java.util.Vector;
import org.scribble.protocol.model.Activity;
import org.scribble.protocol.model.Block;
import org.scribble.protocol.model.ContainmentList;
import org.scribble.protocol.model.DefaultVisitor;
import org.scribble.protocol.model.ModelObject;
import org.scribble.protocol.model.ParameterDefinition;
import org.scribble.protocol.model.ProtocolModel;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.model.RoleList;
import org.scribble.protocol.model.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Protocol
extends Activity {
    private static final long serialVersionUID = 5352253730676464788L;
    private String m_name = null;
    private Role m_role = null;
    private boolean m_stateless = false;
    private Block m_block = null;
    private List<ParameterDefinition> m_parameterDefs = new ContainmentList<ParameterDefinition>(this, ParameterDefinition.class);

    @Override
    public boolean isScope() {
        return true;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public Role getRole() {
        return this.m_role;
    }

    public void setRole(Role role) {
        if (this.m_role != null) {
            this.m_role.setParent(null);
        }
        this.m_role = role;
        if (this.m_role != null) {
            this.m_role.setParent(this);
        }
    }

    public boolean isStateless() {
        return this.m_stateless;
    }

    public void setStateless(boolean stateless) {
        this.m_stateless = stateless;
    }

    public List<ParameterDefinition> getParameterDefinitions() {
        return this.m_parameterDefs;
    }

    public Block getBlock() {
        if (this.m_block == null) {
            this.m_block = new Block();
            this.m_block.setParent(this);
        }
        return this.m_block;
    }

    public void setBlock(Block block) {
        if (this.m_block != null) {
            this.m_block.setParent(null);
        }
        this.m_block = block;
        if (this.m_block != null) {
            this.m_block.setParent(this);
        }
    }

    @Override
    public ProtocolModel getModel() {
        ProtocolModel ret = null;
        ModelObject cur = this;
        while (ret == null && cur != null) {
            if (cur instanceof ProtocolModel) {
                ret = (ProtocolModel)cur;
                continue;
            }
            cur = cur.getParent();
        }
        return ret;
    }

    @Override
    public Protocol enclosingProtocol() {
        return this;
    }

    public Protocol getTopLevelProtocol() {
        Protocol ret = this;
        if (this.getParent() instanceof Protocol) {
            ret = ((Protocol)this.getParent()).getTopLevelProtocol();
        }
        return ret;
    }

    public Protocol getSubProtocol(String name) {
        Protocol ret = null;
        for (int i = 0; ret == null && i < this.getBlock().getContents().size(); ++i) {
            Activity act = this.getBlock().getContents().get(i);
            if (!(act instanceof Protocol) || !((Protocol)act).getName().equals(name)) continue;
            ret = (Protocol)act;
        }
        return ret;
    }

    @Override
    protected Role locatedRole() {
        return this.getRole();
    }

    public List<Role> getRoles() {
        final Vector<Role> ret = new Vector<Role>();
        for (ParameterDefinition p : this.getParameterDefinitions()) {
            if (!p.isRole()) continue;
            ret.add(p.getRole());
        }
        this.visit(new DefaultVisitor(){

            public boolean start(Protocol elem) {
                return Protocol.this == elem;
            }

            public void accept(RoleList elem) {
                ret.addAll(elem.getRoles());
            }
        });
        return ret;
    }

    @Override
    public void visit(Visitor visitor) {
        if (visitor.start(this)) {
            if (this.getRole() != null) {
                this.getRole().visit(visitor);
            }
            if (this.getBlock() != null) {
                this.getBlock().visit(visitor);
            }
        }
        visitor.end(this);
    }
}

