/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.validation;

import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.scribble.common.logging.Journal;
import org.scribble.protocol.model.ProtocolModel;
import org.scribble.protocol.validation.ProtocolValidationManager;
import org.scribble.protocol.validation.ProtocolValidator;

public class DefaultProtocolValidationManager
implements ProtocolValidationManager {
    private List<ProtocolValidator> m_validators = new Vector<ProtocolValidator>();
    private static final Logger logger = Logger.getLogger(DefaultProtocolValidationManager.class.getName());

    public void addValidator(ProtocolValidator validator) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Register validator: " + validator);
        }
        this.m_validators.add(validator);
    }

    public void removeValidator(ProtocolValidator validator) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Unregister validator: " + validator);
        }
        this.m_validators.remove(validator);
    }

    public void validate(ProtocolModel model, Journal logger) {
        for (ProtocolValidator v : this.m_validators) {
            v.validate(model, logger);
        }
    }
}

