/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.validation.rules;

import java.text.MessageFormat;
import java.util.PropertyResourceBundle;
import org.scribble.common.logging.Journal;
import org.scribble.protocol.model.Catch;
import org.scribble.protocol.model.Interaction;
import org.scribble.protocol.model.ModelObject;
import org.scribble.protocol.model.Try;
import org.scribble.protocol.validation.ProtocolComponentValidatorRule;

public class TryValidatorRule
implements ProtocolComponentValidatorRule {
    public boolean isSupported(ModelObject obj) {
        return obj.getClass() == Try.class;
    }

    public void validate(ModelObject obj, Journal logger) {
        Try elem = (Try)obj;
        Interaction first = null;
        for (Catch c : elem.getCatches()) {
            int i;
            if (c.getInteractions().size() == 0) {
                logger.error(MessageFormat.format(PropertyResourceBundle.getBundle("org.scribble.protocol.Messages").getString("_CATCH_NO_INTERACTIONS"), null), obj.getProperties());
                continue;
            }
            if (first == null) {
                first = c.getInteractions().get(0);
                if (c.getInteractions().size() <= 1) continue;
                for (i = 1; i < c.getInteractions().size(); ++i) {
                    this.validateInteraction(first, c.getInteractions().get(i), logger);
                }
                continue;
            }
            for (i = 0; i < c.getInteractions().size(); ++i) {
                this.validateInteraction(first, c.getInteractions().get(i), logger);
            }
        }
    }

    protected void validateInteraction(Interaction ref, Interaction interaction, Journal logger) {
        boolean inconsistent = false;
        if (ref.getFromRole() == null && interaction.getFromRole() != null || ref.getFromRole() != null && interaction.getFromRole() == null || ref.getFromRole() != null && !ref.getFromRole().equals(interaction.getFromRole())) {
            inconsistent = true;
        }
        if (ref.getToRoles().size() != interaction.getToRoles().size()) {
            inconsistent = true;
        } else {
            for (int i = 0; !inconsistent && i < ref.getToRoles().size(); ++i) {
                if (interaction.getToRoles().contains(ref.getToRoles().get(i))) continue;
                inconsistent = true;
            }
        }
        if (inconsistent) {
            logger.error(MessageFormat.format(PropertyResourceBundle.getBundle("org.scribble.protocol.Messages").getString("_CATCH_INCONSISTENT_ROLES"), null), interaction.getProperties());
        }
    }
}

