/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.util;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.scribble.protocol.model.Activity;
import org.scribble.protocol.model.Block;
import org.scribble.protocol.model.Catch;
import org.scribble.protocol.model.Choice;
import org.scribble.protocol.model.Include;
import org.scribble.protocol.model.Interaction;
import org.scribble.protocol.model.Optional;
import org.scribble.protocol.model.Parallel;
import org.scribble.protocol.model.ParameterDefinition;
import org.scribble.protocol.model.Protocol;
import org.scribble.protocol.model.ProtocolImport;
import org.scribble.protocol.model.ProtocolImportList;
import org.scribble.protocol.model.Raise;
import org.scribble.protocol.model.RecBlock;
import org.scribble.protocol.model.Recursion;
import org.scribble.protocol.model.Repeat;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.model.RoleList;
import org.scribble.protocol.model.Run;
import org.scribble.protocol.model.Try;
import org.scribble.protocol.model.TypeImport;
import org.scribble.protocol.model.TypeImportList;
import org.scribble.protocol.model.Unordered;
import org.scribble.protocol.model.Visitor;
import org.scribble.protocol.model.When;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoleUtil {
    public static Set<Role> getRoles(Block block) {
        HashSet<Role> ret = new HashSet<Role>();
        for (int i = 0; i < block.getContents().size(); ++i) {
            if (!(block.getContents().get(i) instanceof RoleList)) continue;
            ret.addAll(((RoleList)block.getContents().get(i)).getRoles());
        }
        return ret;
    }

    public static Set<Role> getRolesInScope(Activity activity) {
        Protocol protocol;
        HashSet<Role> ret = new HashSet<Role>();
        if (activity != null && (protocol = activity.enclosingProtocol()) != null) {
            RoleLocator visitor = new RoleLocator(protocol, activity, ret);
            protocol.visit(visitor);
        }
        return ret;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RoleLocator
    implements Visitor {
        private boolean m_recurse = true;
        private Protocol m_protocol = null;
        private Activity m_activity = null;
        private Set<Role> m_result = null;
        private List<List<Role>> m_roleStack = new Vector<List<Role>>();

        public RoleLocator(Protocol protocol, Activity activity, Set<Role> result) {
            this.m_protocol = protocol;
            this.m_activity = activity;
            this.m_result = result;
        }

        @Override
        public boolean start(Block elem) {
            return this.startBlock(elem);
        }

        protected boolean startBlock(Block elem) {
            this.m_roleStack.add(new Vector());
            return true;
        }

        @Override
        public void end(Block elem) {
            this.endBlock(elem);
        }

        protected void endBlock(Block elem) {
            this.m_roleStack.remove(this.m_roleStack.size() - 1);
        }

        @Override
        public void end(Choice elem) {
        }

        @Override
        public void end(Optional elem) {
        }

        @Override
        public void end(Unordered elem) {
        }

        @Override
        public void end(Parallel elem) {
        }

        @Override
        public void end(Protocol elem) {
        }

        @Override
        public void end(Repeat elem) {
        }

        @Override
        public void end(RecBlock elem) {
        }

        @Override
        public void end(Try elem) {
        }

        @Override
        public void end(Catch elem) {
        }

        @Override
        public void end(Run elem) {
        }

        @Override
        public boolean start(Choice elem) {
            this.checkActivity(elem);
            return this.m_recurse;
        }

        @Override
        public boolean start(When elem) {
            return this.m_recurse;
        }

        @Override
        public void end(When elem) {
        }

        @Override
        public boolean start(Optional elem) {
            this.checkActivity(elem);
            return this.m_recurse;
        }

        @Override
        public boolean start(Unordered elem) {
            this.checkActivity(elem);
            return this.m_recurse;
        }

        @Override
        public boolean start(Parallel elem) {
            this.checkActivity(elem);
            return this.m_recurse;
        }

        @Override
        public boolean start(Protocol elem) {
            boolean ret;
            boolean bl = ret = this.m_protocol == elem;
            if (ret) {
                Vector<Role> rlist = new Vector<Role>();
                this.m_roleStack.add(rlist);
                if (elem.getRole() != null) {
                    rlist.add(elem.getRole());
                }
                for (ParameterDefinition p : elem.getParameterDefinitions()) {
                    if (p.getType() != null) continue;
                    rlist.add(new Role(p.getName()));
                }
            }
            return ret;
        }

        @Override
        public boolean start(Repeat elem) {
            this.checkActivity(elem);
            return this.m_recurse;
        }

        @Override
        public boolean start(RecBlock elem) {
            this.checkActivity(elem);
            return this.m_recurse;
        }

        @Override
        public boolean start(Try elem) {
            this.checkActivity(elem);
            return this.m_recurse;
        }

        @Override
        public boolean start(Catch elem) {
            for (Interaction interaction : elem.getInteractions()) {
                this.checkActivity(interaction);
            }
            return this.m_recurse;
        }

        @Override
        public boolean start(Run elem) {
            this.checkActivity(elem);
            return this.m_recurse;
        }

        @Override
        public void accept(TypeImportList elem) {
        }

        @Override
        public void accept(ProtocolImportList elem) {
        }

        @Override
        public void accept(Interaction elem) {
            this.checkActivity(elem);
        }

        @Override
        public void accept(RoleList elem) {
            List<Role> rlist = this.m_roleStack.get(this.m_roleStack.size() - 1);
            rlist.addAll(elem.getRoles());
        }

        @Override
        public void accept(Raise elem) {
            this.checkActivity(elem);
        }

        @Override
        public void accept(Include elem) {
            this.checkActivity(elem);
        }

        @Override
        public void accept(Recursion elem) {
            this.checkActivity(elem);
        }

        @Override
        public void accept(TypeImport elem) {
        }

        @Override
        public void accept(ProtocolImport elem) {
        }

        protected void checkActivity(Activity elem) {
            if (elem == this.m_activity) {
                for (List<Role> plist : this.m_roleStack) {
                    for (Role p : plist) {
                        this.m_result.add(p);
                    }
                }
                this.m_recurse = false;
            }
        }
    }
}

