/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol;

import java.net.MalformedURLException;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.scribble.common.logging.Journal;
import org.scribble.common.resource.Content;
import org.scribble.common.resource.ResourceContent;
import org.scribble.common.resource.ResourceLocator;
import org.scribble.protocol.ProtocolContext;
import org.scribble.protocol.model.ProtocolImport;
import org.scribble.protocol.model.ProtocolModel;
import org.scribble.protocol.parser.ProtocolParserManager;

public class DefaultProtocolContext
implements ProtocolContext {
    private ProtocolParserManager m_parserManager = null;
    private ResourceLocator m_resourceLocator = null;
    private static Logger logger = Logger.getLogger(DefaultProtocolContext.class.getName());

    public DefaultProtocolContext(ProtocolParserManager parserManager, ResourceLocator locator) {
        this.m_parserManager = parserManager;
        this.m_resourceLocator = locator;
    }

    public ResourceLocator getResourceLocator() {
        return this.m_resourceLocator;
    }

    public ProtocolModel getProtocolModel(ProtocolImport pi, Journal journal) {
        ProtocolModel ret = null;
        if (pi.getLocation() == null || pi.getLocation().trim().length() == 0) {
            journal.error("Protocol import does not define a location", pi.getProperties());
        } else {
            try {
                URI uri = this.getResourceLocator().getResourceURI(pi.getLocation());
                ResourceContent content = new ResourceContent(uri);
                ret = this.m_parserManager.parse((Content)content, journal, this);
            }
            catch (MalformedURLException mue) {
                journal.error("Invalid URL '" + mue + "'", pi.getProperties());
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to read protocol from '" + pi.getLocation() + "'", e);
                journal.error("Failed to read protocol from '" + pi.getLocation() + "'", pi.getProperties());
            }
        }
        return ret;
    }
}

