/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.export.text;

import java.io.OutputStream;
import org.scribble.common.logging.Journal;
import org.scribble.common.model.Annotation;
import org.scribble.protocol.model.Block;
import org.scribble.protocol.model.Choice;
import org.scribble.protocol.model.DirectedChoice;
import org.scribble.protocol.model.Do;
import org.scribble.protocol.model.End;
import org.scribble.protocol.model.Include;
import org.scribble.protocol.model.Interaction;
import org.scribble.protocol.model.Interrupt;
import org.scribble.protocol.model.Introduces;
import org.scribble.protocol.model.MessageSignature;
import org.scribble.protocol.model.OnMessage;
import org.scribble.protocol.model.Parallel;
import org.scribble.protocol.model.ParameterDefinition;
import org.scribble.protocol.model.Protocol;
import org.scribble.protocol.model.ProtocolImport;
import org.scribble.protocol.model.ProtocolImportList;
import org.scribble.protocol.model.RecBlock;
import org.scribble.protocol.model.Recursion;
import org.scribble.protocol.model.Repeat;
import org.scribble.protocol.model.Run;
import org.scribble.protocol.model.TypeImport;
import org.scribble.protocol.model.TypeImportList;
import org.scribble.protocol.model.Unordered;
import org.scribble.protocol.model.Visitor;

public class TextProtocolExporterVisitor
implements Visitor {
    private OutputStream m_outputStream = null;
    private Journal m_journal = null;
    private int m_indent = 0;
    private Exception m_exception = null;

    public TextProtocolExporterVisitor(Journal journal, OutputStream os) {
        this.m_journal = journal;
        this.m_outputStream = os;
    }

    public boolean start(Block elem) {
        if (elem.getParent() instanceof Parallel && ((Parallel)elem.getParent()).getBlocks().indexOf(elem) > 0) {
            this.output(" and");
        } else if (elem.getParent() instanceof Choice && ((Choice)elem.getParent()).getBlocks().indexOf(elem) > 0) {
            this.output(" or");
        }
        if (!(elem.getParent() instanceof OnMessage)) {
            this.output(" {\r\n");
        }
        ++this.m_indent;
        return true;
    }

    public void end(Block elem) {
        --this.m_indent;
        this.indent();
        if (!(elem.getParent() instanceof OnMessage)) {
            this.output("}");
        }
        if (this.isEndOfBlock(elem)) {
            this.output("\r\n");
        }
    }

    protected boolean isEndOfBlock(Block elem) {
        boolean ret = true;
        if (elem.getParent() instanceof Parallel) {
            ret = ((Parallel)elem.getParent()).getBlocks().indexOf(elem) == ((Parallel)elem.getParent()).getBlocks().size() - 1;
        } else if (elem.getParent() instanceof Choice) {
            ret = ((Choice)elem.getParent()).getBlocks().indexOf(elem) == ((Choice)elem.getParent()).getBlocks().size() - 1;
        } else if (elem.getParent() instanceof Interrupt) {
            Interrupt c = (Interrupt)elem.getParent();
            if (c.getParent() instanceof Do) {
                Do te = (Do)c.getParent();
                ret = te.getInterrupts().indexOf(c) == te.getInterrupts().size() - 1;
            }
        } else if (elem.getParent() instanceof Do) {
            ret = ((Do)elem.getParent()).getInterrupts().size() == 0;
        }
        return ret;
    }

    public void accept(TypeImportList elem) {
        for (Annotation annotation : elem.getAnnotations()) {
            this.output("[[" + annotation.toString() + "]]\r\n");
        }
        this.output("import ");
        boolean f_first = true;
        if (elem.getFormat() != null) {
            this.output(elem.getFormat() + " ");
        }
        for (TypeImport t : elem.getTypeImports()) {
            if (!f_first) {
                this.output(", ");
            }
            f_first = false;
            if (t.getDataType() != null && t.getDataType().getDetails() != null) {
                this.output("\"" + t.getDataType().getDetails() + "\" as ");
            }
            this.output(t.getName());
        }
        if (elem.getLocation() != null) {
            this.output(" from \"" + elem.getLocation() + "\"");
        }
        this.output(";\r\n");
    }

    public void accept(ProtocolImportList elem) {
        for (Annotation annotation : elem.getAnnotations()) {
            this.output("[[" + annotation.toString() + "]]\r\n");
        }
        this.output("import protocol ");
        boolean f_first = true;
        for (ProtocolImport t : elem.getProtocolImports()) {
            if (!f_first) {
                this.output(", ");
            }
            f_first = false;
            this.output(t.getName());
            this.output(" from \"" + t.getLocation() + "\"");
        }
        this.output(";\r\n");
    }

    public void accept(Introduces elem) {
        for (Annotation annotation : elem.getAnnotations()) {
            this.indent();
            this.output("[[" + annotation.toString() + "]]\r\n");
        }
        this.indent();
        this.output(elem.getIntroducer().getName());
        this.output(" introduces ");
        for (int i = 0; i < elem.getRoles().size(); ++i) {
            if (i > 0) {
                this.output(", ");
            }
            this.output(elem.getRoles().get(i).getName());
        }
        this.output(";\r\n");
    }

    public void accept(Interaction elem) {
        if (!(elem.getParent() instanceof Interrupt)) {
            for (Annotation annotation : elem.getAnnotations()) {
                this.indent();
                this.output("[[" + annotation.toString() + "]]\r\n");
            }
            this.indent();
            this.outputInteraction(elem);
            this.output(";\r\n");
        }
    }

    protected void outputInteraction(Interaction elem) {
        this.outputMessageSignature(elem.getMessageSignature());
        if (elem.getFromRole() != null) {
            this.output(" from " + elem.getFromRole().getName());
        }
        if (elem.getToRoles().size() > 0) {
            this.output(" to ");
            for (int i = 0; i < elem.getToRoles().size(); ++i) {
                if (i > 0) {
                    this.output(",");
                }
                this.output(elem.getToRoles().get(i).getName());
            }
        }
    }

    public void accept(Recursion elem) {
        for (Annotation annotation : elem.getAnnotations()) {
            this.indent();
            this.output("[[" + annotation.toString() + "]]\r\n");
        }
        this.indent();
        if (elem.getLabel() != null) {
            this.output(elem.getLabel());
        }
        this.output(";\r\n");
    }

    public boolean start(Protocol elem) {
        for (Annotation annotation : elem.getAnnotations()) {
            this.indent();
            this.output("[[" + annotation.toString() + "]]\r\n");
        }
        this.indent();
        this.output("protocol " + elem.getName());
        if (elem.getRole() != null) {
            this.output(" @ " + elem.getRole().getName());
        }
        if (elem.getParameterDefinitions().size() > 0) {
            this.output("(");
            for (int i = 0; i < elem.getParameterDefinitions().size(); ++i) {
                ParameterDefinition pd = elem.getParameterDefinitions().get(i);
                if (i > 0) {
                    this.output(", ");
                }
                if (pd.getRole() != null) {
                    this.output("role " + pd.getRole().getName());
                    continue;
                }
                this.output(pd.getType().getName() + " " + pd.getName());
            }
            this.output(")");
        }
        return true;
    }

    public boolean start(Choice elem) {
        for (Annotation annotation : elem.getAnnotations()) {
            this.indent();
            this.output("[[" + annotation.toString() + "]]\r\n");
        }
        this.indent();
        this.output("choice");
        if (elem.getRole() != null) {
            this.output(" at " + elem.getRole().getName());
        }
        return true;
    }

    public boolean start(DirectedChoice elem) {
        for (Annotation annotation : elem.getAnnotations()) {
            this.indent();
            this.output("[[" + annotation.toString() + "]]\r\n");
        }
        this.indent();
        if (elem.getFromRole() != null) {
            this.output("from " + elem.getFromRole().getName() + " ");
        }
        if (elem.getToRoles().size() > 0) {
            this.output("to ");
            for (int i = 0; i < elem.getToRoles().size(); ++i) {
                if (i > 0) {
                    this.output(", ");
                }
                this.output(elem.getToRoles().get(i).getName());
            }
        }
        this.output(" {\r\n");
        ++this.m_indent;
        return true;
    }

    public boolean start(OnMessage elem) {
        for (Annotation annotation : elem.getAnnotations()) {
            this.indent();
            this.output("[[" + annotation.toString() + "]]\r\n");
        }
        this.indent();
        this.outputMessageSignature(elem.getMessageSignature());
        this.output(":\r\n");
        return true;
    }

    public void end(Choice elem) {
    }

    public void end(DirectedChoice elem) {
        --this.m_indent;
        this.indent();
        this.output("}\r\n");
    }

    public void end(OnMessage elem) {
    }

    public boolean start(Interrupt elem) {
        this.indent();
        this.output(" interrupt");
        return true;
    }

    private void outputMessageSignature(MessageSignature ms) {
        if (ms != null) {
            if (ms.getOperation() != null) {
                this.output(ms.getOperation() + "(");
                for (int i = 0; i < ms.getTypeReferences().size(); ++i) {
                    if (i > 0) {
                        this.output(", ");
                    }
                    this.output(ms.getTypeReferences().get(i).getName());
                }
                this.output(")");
            } else if (ms.getTypeReferences().size() > 0) {
                this.output(ms.getTypeReferences().get(0).getName());
            }
        }
    }

    public void accept(Run elem) {
        for (Annotation annotation : elem.getAnnotations()) {
            this.indent();
            this.output("[[" + annotation.toString() + "]]\r\n");
        }
        this.indent();
        this.output("run " + elem.getProtocolReference().getName());
        if (elem.getProtocolReference().getRole() != null) {
            this.output("@" + elem.getProtocolReference().getRole().getName());
        }
        if (elem.getParameters().size() > 0) {
            this.output("(");
            for (int i = 0; i < elem.getParameters().size(); ++i) {
                if (i > 0) {
                    this.output(", ");
                }
                this.output(elem.getParameters().get(i).getName());
            }
            this.output(")");
        }
        if (elem.getFromRole() != null) {
            this.output(" from " + elem.getFromRole().getName());
        }
        this.output(";\r\n");
    }

    public boolean start(Parallel elem) {
        for (Annotation annotation : elem.getAnnotations()) {
            this.indent();
            this.output("[[" + annotation.toString() + "]]\r\n");
        }
        this.indent();
        this.output("parallel");
        return true;
    }

    public void end(Parallel elem) {
    }

    public boolean start(Do elem) {
        for (Annotation annotation : elem.getAnnotations()) {
            this.indent();
            this.output("[[" + annotation.toString() + "]]\r\n");
        }
        this.indent();
        this.output("do");
        return true;
    }

    public void end(Do elem) {
    }

    public boolean start(Repeat elem) {
        for (Annotation annotation : elem.getAnnotations()) {
            this.indent();
            this.output("[[" + annotation.toString() + "]]\r\n");
        }
        this.indent();
        this.output("repeat");
        if (elem.getRoles().size() > 0) {
            this.output(" @ ");
            for (int i = 0; i < elem.getRoles().size(); ++i) {
                if (i > 0) {
                    this.output(",");
                }
                this.output(elem.getRoles().get(i).getName());
            }
        }
        return true;
    }

    public void end(Repeat elem) {
    }

    public boolean start(Unordered elem) {
        for (Annotation annotation : elem.getAnnotations()) {
            this.indent();
            this.output("[[" + annotation.toString() + "]]\r\n");
        }
        this.indent();
        this.output("unordered");
        return true;
    }

    public void end(Unordered elem) {
    }

    public boolean start(RecBlock elem) {
        for (Annotation annotation : elem.getAnnotations()) {
            this.indent();
            this.output("[[" + annotation.toString() + "]]\r\n");
        }
        this.indent();
        if (elem.getLabel() != null) {
            this.output("rec " + elem.getLabel());
        }
        return true;
    }

    public void end(RecBlock elem) {
    }

    protected void indent() {
        for (int i = 0; i < this.m_indent; ++i) {
            this.output("\t");
        }
    }

    protected void output(String str) {
        try {
            this.m_outputStream.write(str.getBytes());
        }
        catch (Exception e) {
            this.m_exception = e;
        }
    }

    public Exception getException() {
        return this.m_exception;
    }

    public Journal getJournal() {
        return this.m_journal;
    }

    public void end(Protocol elem) {
    }

    public void end(Interrupt elem) {
    }

    public void accept(Include elem) {
    }

    public void accept(TypeImport elem) {
    }

    public void accept(ProtocolImport elem) {
    }

    public void accept(End elem) {
        for (Annotation annotation : elem.getAnnotations()) {
            this.indent();
            this.output("[[" + annotation.toString() + "]]\r\n");
        }
        this.indent();
        this.output("end;\r\n");
    }
}

