/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.model;

import java.util.Collection;
import java.util.List;
import org.scribble.protocol.model.ContainmentList;
import org.scribble.protocol.model.ModelObject;
import org.scribble.protocol.model.TypeReference;
import org.scribble.protocol.model.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageSignature
extends ModelObject {
    private String _operation = null;
    private List<TypeReference> _typeReferences = new ContainmentList<TypeReference>(this, TypeReference.class);

    public MessageSignature() {
    }

    public MessageSignature(TypeReference typeRef) {
        this._typeReferences.add(typeRef);
    }

    public MessageSignature(String operation, Collection<TypeReference> typeRefs) {
        this._operation = operation;
        this._typeReferences.addAll(typeRefs);
    }

    public MessageSignature(MessageSignature msig) {
        super(msig);
        this._operation = msig.getOperation();
        for (TypeReference tref : msig.getTypeReferences()) {
            this._typeReferences.add(new TypeReference(tref));
        }
    }

    public String getOperation() {
        return this._operation;
    }

    public void setOperation(String operation) {
        this._operation = operation;
    }

    public List<TypeReference> getTypeReferences() {
        return this._typeReferences;
    }

    public int hashCode() {
        int result = 13;
        result = 31 * result + ((Object)this._typeReferences).hashCode();
        result = 31 * result + (this._operation == null ? 0 : this._operation.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        MessageSignature other;
        boolean ret = false;
        if (obj instanceof MessageSignature && (other = (MessageSignature)obj).getTypeReferences().size() == this.getTypeReferences().size()) {
            if (other._operation != null && this._operation != null) {
                ret = other._operation.equals(this._operation);
            } else if (other._operation == null && this._operation == null) {
                ret = true;
            }
            for (int i = 0; ret && i < this.getTypeReferences().size(); ++i) {
                ret = this.getTypeReferences().get(i).equals(other.getTypeReferences().get(i));
            }
        }
        return ret;
    }

    public String toString() {
        String ret = "";
        if (this.getOperation() != null && this.getOperation().trim().length() > 0) {
            ret = ret + this.getOperation() + "(";
        }
        for (int i = 0; i < this._typeReferences.size(); ++i) {
            if (i > 0) {
                ret = ret + ",";
            }
            ret = ret + this._typeReferences.get(i).getName();
        }
        if (this.getOperation() != null && this.getOperation().trim().length() > 0) {
            ret = ret + ")";
        }
        if (ret.equals("")) {
            ret = "<No Signature>";
        }
        return ret;
    }

    @Override
    public void visit(Visitor visitor) {
    }
}

