/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.model;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.scribble.protocol.model.ModelObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainmentList<E extends ModelObject>
extends Vector<E>
implements List<E> {
    private static final long serialVersionUID = -1265091580286297521L;
    private ModelObject _parent = null;
    private Class<E> _type = null;

    public ContainmentList(ModelObject parent, Class<E> type) {
        this._parent = parent;
        this._type = type;
    }

    public Class<E> getType() {
        return this._type;
    }

    @Override
    public boolean add(E o) {
        boolean ret = super.add(o);
        if (ret) {
            ((ModelObject)o).setParent(this._parent);
        }
        return ret;
    }

    @Override
    public boolean remove(Object o) {
        boolean ret = super.remove(o);
        if (ret && o instanceof ModelObject) {
            ((ModelObject)o).setParent(null);
        }
        return ret;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean ret = super.addAll(c);
        if (ret) {
            Iterator<E> iter = c.iterator();
            while (iter.hasNext()) {
                ((ModelObject)iter.next()).setParent(this._parent);
            }
        }
        return ret;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        boolean ret = super.addAll(index, c);
        if (ret) {
            Iterator<E> iter = c.iterator();
            while (iter.hasNext()) {
                ((ModelObject)iter.next()).setParent(this._parent);
            }
        }
        return ret;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean ret = super.removeAll(c);
        if (ret) {
            for (Object val : c) {
                if (!(val instanceof ModelObject)) continue;
                ((ModelObject)val).setParent(null);
            }
        }
        return ret;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return super.retainAll(c);
    }

    @Override
    public void clear() {
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            ((ModelObject)iter.next()).setParent(null);
        }
        super.clear();
    }

    @Override
    public E set(int index, E element) {
        ModelObject ret = (ModelObject)super.set(index, element);
        if (element != null) {
            ((ModelObject)element).setParent(this._parent);
        }
        if (ret != null) {
            ret.setParent(null);
        }
        return (E)ret;
    }

    @Override
    public void add(int index, E element) {
        super.add(index, element);
        if (element != null) {
            ((ModelObject)element).setParent(this._parent);
        }
    }

    @Override
    public E remove(int index) {
        ModelObject ret = (ModelObject)super.remove(index);
        if (ret != null) {
            ret.setParent(null);
        }
        return (E)ret;
    }
}

