/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.model;

import java.util.List;
import org.scribble.protocol.model.Activity;
import org.scribble.protocol.model.ContainmentList;
import org.scribble.protocol.model.OnMessage;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.model.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectedChoice
extends Activity {
    private Role _fromRole = null;
    private List<Role> _toRoles = new ContainmentList<Role>(this, Role.class);
    private List<OnMessage> _onMessages = new ContainmentList<OnMessage>(this, OnMessage.class);

    public Role getFromRole() {
        return this._fromRole;
    }

    public void setFromRole(Role part) {
        this._fromRole = part;
    }

    public List<Role> getToRoles() {
        return this._toRoles;
    }

    public List<OnMessage> getOnMessages() {
        return this._onMessages;
    }

    @Override
    public void visit(Visitor visitor) {
        if (visitor.start(this)) {
            for (OnMessage om : this.getOnMessages()) {
                om.visit(visitor);
            }
        }
        visitor.end(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DirectedChoice that = (DirectedChoice)o;
        return !(this._fromRole == null ? that._fromRole != null : !this._fromRole.equals(that._fromRole)) && ((Object)this._onMessages).equals(that._onMessages);
    }

    public int hashCode() {
        int result = ((Object)this._onMessages).hashCode();
        result = 31 * result + (this._fromRole != null ? this._fromRole.hashCode() : 0);
        return result;
    }

    public String toString() {
        String result = "";
        if (this._fromRole != null) {
            result = result + "from " + this._fromRole + " ";
        }
        if (this._toRoles.size() > 0) {
            result = result + "to ";
            for (int i = 0; i < this._toRoles.size(); ++i) {
                if (i > 0) {
                    result = result + ", ";
                }
                result = result + this._toRoles.get(i);
            }
        }
        for (OnMessage b : this._onMessages) {
            if (this._onMessages.indexOf(b) > 0) {
                result = result + "or ";
            }
            result = result + b + "\n";
        }
        return result;
    }
}

