/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.validation.rules;

import java.text.MessageFormat;
import java.util.PropertyResourceBundle;
import java.util.Vector;
import org.scribble.common.logging.CachedJournal;
import org.scribble.common.logging.Journal;
import org.scribble.protocol.model.ModelObject;
import org.scribble.protocol.model.ProtocolModel;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.validation.ProtocolComponentValidatorRule;
import org.scribble.protocol.validation.ProtocolValidatorContext;

public class ProtocolModelValidatorRule
implements ProtocolComponentValidatorRule {
    public boolean isSupported(ModelObject obj) {
        return obj.getClass() == ProtocolModel.class && !((ProtocolModel)obj).isLocated();
    }

    public void validate(ProtocolValidatorContext pvc, ModelObject obj, Journal logger) {
        ProtocolModel elem = (ProtocolModel)obj;
        Vector<Role> unprojectable = new Vector<Role>();
        for (Role role : elem.getRoles()) {
            CachedJournal l = new CachedJournal();
            pvc.getProtocolProjector().project(pvc.getProtocolContext(), elem, role, (Journal)l);
            if (!l.hasErrors()) continue;
            unprojectable.add(role);
        }
        if (unprojectable.size() > 0) {
            String roleNames = "";
            for (int i = 0; i < unprojectable.size(); ++i) {
                if (i > 0) {
                    roleNames = i == unprojectable.size() - 1 ? roleNames + " & " : roleNames + ", ";
                }
                roleNames = roleNames + ((Role)unprojectable.get(i)).getName();
            }
            logger.error(MessageFormat.format(PropertyResourceBundle.getBundle("org.scribble.protocol.Messages").getString("_UNPROJECTABLE_ROLES"), roleNames), obj.getProperties());
        }
    }
}

