/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.validation.rules;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.PropertyResourceBundle;
import java.util.Set;
import java.util.Stack;
import org.scribble.common.logging.Journal;
import org.scribble.protocol.ProtocolDefinitions;
import org.scribble.protocol.model.Activity;
import org.scribble.protocol.model.Block;
import org.scribble.protocol.model.Choice;
import org.scribble.protocol.model.DefaultVisitor;
import org.scribble.protocol.model.DirectedChoice;
import org.scribble.protocol.model.Interaction;
import org.scribble.protocol.model.Introduces;
import org.scribble.protocol.model.ModelObject;
import org.scribble.protocol.model.Parameter;
import org.scribble.protocol.model.ParameterDefinition;
import org.scribble.protocol.model.Protocol;
import org.scribble.protocol.model.RecBlock;
import org.scribble.protocol.model.Repeat;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.model.Run;
import org.scribble.protocol.validation.ProtocolComponentValidatorRule;
import org.scribble.protocol.validation.ProtocolValidatorContext;

public class ProtocolValidatorRule
implements ProtocolComponentValidatorRule {
    public boolean isSupported(ModelObject obj) {
        return obj.getClass() == Protocol.class;
    }

    public void validate(ProtocolValidatorContext pvc, ModelObject obj, Journal logger) {
        Protocol elem = (Protocol)obj;
        if (elem.getLocatedRole() == null) {
            elem.visit(new ConnectednessVisitor(elem, logger));
        }
        if (elem.getName() != null) {
            String name = elem.getName().toLowerCase();
            boolean reservedWord = false;
            for (String reserved : ProtocolDefinitions.RESERVED_WORDS) {
                if (!reserved.equals(name)) continue;
                reservedWord = true;
                break;
            }
            if (reservedWord) {
                logger.error(MessageFormat.format(PropertyResourceBundle.getBundle("org.scribble.protocol.Messages").getString("_CANNOT_USE_RESERVED_WORD"), elem.getName()), elem.getProperties());
            }
        }
        if (pvc != null) {
            for (ParameterDefinition pd : elem.getParameterDefinitions()) {
                if (pvc.getState(pd.getName()) != null) {
                    logger.error(MessageFormat.format(PropertyResourceBundle.getBundle("org.scribble.protocol.Messages").getString("_NAME_ALREADY_DEFINED"), pd.getName()), pd.getProperties());
                    continue;
                }
                if (pd.isRole()) {
                    pvc.setState(pd.getName(), new Role(pd.getName()));
                    continue;
                }
                pvc.setState(pd.getName(), pd);
            }
        }
    }

    protected class ConnectednessVisitor
    extends DefaultVisitor {
        private Protocol _protocol = null;
        private Journal _logger = null;
        private Stack<Set<Role>> _roleStack = new Stack();
        private Stack<Stack<Set<Role>>> _saveStack = new Stack();

        public ConnectednessVisitor(Protocol p, Journal logger) {
            this._protocol = p;
            this._logger = logger;
        }

        protected boolean isRoleKnown(Role r) {
            boolean ret = false;
            for (Set set : this._roleStack) {
                if (!set.contains(r)) continue;
                ret = true;
                break;
            }
            return ret;
        }

        protected void validate(Activity act, Role r) {
            if (r != null && !this.isRoleKnown(r)) {
                this._logger.error(MessageFormat.format(PropertyResourceBundle.getBundle("org.scribble.protocol.Messages").getString("_UNCONNECTED_ROLE"), r.getName()), act.getProperties());
            }
        }

        protected void addRole(Role r) {
            if (!this.isRoleKnown(r)) {
                Set<Role> roles = this._roleStack.peek();
                roles.add(r);
            }
        }

        protected void push() {
            if (this._roleStack == null) {
                this._roleStack = new Stack();
            }
            this._roleStack.push(new HashSet());
        }

        protected void pop() {
            this._roleStack.pop();
        }

        protected void saveStack() {
            this._saveStack.push(this._roleStack);
            this._roleStack = null;
            this.push();
        }

        protected void restoreStack() {
            this._roleStack = this._saveStack.pop();
        }

        public boolean start(Block elem) {
            this.push();
            return true;
        }

        public void end(Block elem) {
            this.pop();
        }

        public boolean start(Choice elem) {
            this.validate(elem, elem.getRole());
            this.saveStack();
            this.addRole(elem.getRole());
            return true;
        }

        public void end(Choice elem) {
            this.restoreStack();
        }

        public boolean start(DirectedChoice elem) {
            this.validate(elem, elem.getFromRole());
            this.saveStack();
            this.addRole(elem.getFromRole());
            for (Role r : elem.getToRoles()) {
                this.addRole(r);
            }
            return true;
        }

        public void end(DirectedChoice elem) {
            this.restoreStack();
        }

        public boolean start(Protocol elem) {
            if (elem == this._protocol) {
                this.push();
                for (ParameterDefinition pd : elem.getParameterDefinitions()) {
                    if (pd.getType() != null) continue;
                    this.addRole(new Role(pd.getName()));
                }
                return true;
            }
            return false;
        }

        public void end(Protocol elem) {
            if (elem == this._protocol) {
                this.pop();
            }
        }

        public boolean start(Repeat elem) {
            for (Role r : elem.getRoles()) {
                this.validate(elem, r);
            }
            this.saveStack();
            for (Role r : elem.getRoles()) {
                this.addRole(r);
            }
            return true;
        }

        public void end(Repeat elem) {
            this.restoreStack();
        }

        public boolean start(RecBlock elem) {
            this.push();
            return true;
        }

        public void end(RecBlock elem) {
            this.pop();
        }

        public void accept(Run elem) {
            for (Parameter p : elem.getParameters()) {
                this.validate(elem, new Role(p.getName()));
            }
        }

        public void accept(Interaction elem) {
            this.validate(elem, elem.getFromRole());
            this.addRole(elem.getFromRole());
            for (Role r : elem.getToRoles()) {
                this.addRole(r);
            }
        }

        public void accept(Introduces elem) {
            this.validate(elem, elem.getIntroducer());
            this.addRole(elem.getIntroducer());
            for (Role r : elem.getIntroducedRoles()) {
                this.addRole(r);
            }
        }
    }
}

