/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.util;

import org.scribble.protocol.model.ImportList;
import org.scribble.protocol.model.ModelObject;
import org.scribble.protocol.model.ProtocolModel;
import org.scribble.protocol.model.TypeImport;
import org.scribble.protocol.model.TypeImportList;
import org.scribble.protocol.model.TypeReference;

public final class TypesUtil {
    private TypesUtil() {
    }

    public static TypeImport getTypeImport(TypeReference typeRef) {
        TypeImport ret = null;
        String typeName = typeRef.getName();
        ProtocolModel pm = null;
        for (ModelObject cur = typeRef; cur != null; cur = cur.getParent()) {
            if (!(cur instanceof ProtocolModel)) continue;
            pm = (ProtocolModel)cur;
        }
        if (pm != null) {
            for (int i = 0; ret == null && i < pm.getImports().size(); ++i) {
                ImportList imp = pm.getImports().get(i);
                if (!(imp instanceof TypeImportList)) continue;
                ret = ((TypeImportList)imp).getTypeImport(typeName);
            }
        }
        return ret;
    }

    public static TypeImport getTypeImport(ProtocolModel pm, String typeName) {
        TypeImport ret = null;
        if (pm != null && typeName != null) {
            for (int i = 0; ret == null && i < pm.getImports().size(); ++i) {
                ImportList imp = pm.getImports().get(i);
                if (!(imp instanceof TypeImportList)) continue;
                ret = ((TypeImportList)imp).getTypeImport(typeName);
            }
        }
        return ret;
    }

    public static boolean isConcreteTypesDefined(ProtocolModel model) {
        boolean ret = false;
        for (ImportList imp : model.getImports()) {
            if (imp instanceof TypeImportList) {
                for (TypeImport ti : ((TypeImportList)imp).getTypeImports()) {
                    if (ti.getDataType() == null) continue;
                    ret = true;
                    break;
                }
            }
            if (!ret) continue;
            break;
        }
        return ret;
    }
}

