/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.export.text;

import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.List;
import java.util.PropertyResourceBundle;
import java.util.Vector;
import org.scribble.common.logging.Journal;
import org.scribble.protocol.export.ProtocolExporter;
import org.scribble.protocol.export.text.TextProtocolExporterRule;
import org.scribble.protocol.export.text.TextProtocolExporterVisitor;
import org.scribble.protocol.model.ProtocolModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextProtocolExporter
implements ProtocolExporter {
    public static final String TEXT_ID = "txt";
    private List<TextProtocolExporterRule> _rules = new Vector<TextProtocolExporterRule>();

    @Override
    public String getId() {
        return TEXT_ID;
    }

    @Override
    public String getName() {
        return "Text";
    }

    @Override
    public void export(ProtocolModel model, Journal journal, OutputStream os) {
        TextProtocolExporterVisitor visitor = this.createVisitor(journal, os, this._rules);
        model.visit(visitor);
        if (visitor.getException() != null) {
            journal.error(MessageFormat.format(PropertyResourceBundle.getBundle("org.scribble.protocol.Messages").getString("_EXPORT_FAILED"), visitor.getException().getLocalizedMessage()), null);
        }
    }

    protected TextProtocolExporterVisitor createVisitor(Journal journal, OutputStream os) {
        return new TextProtocolExporterVisitor(journal, os);
    }

    protected TextProtocolExporterVisitor createVisitor(Journal journal, OutputStream os, List<TextProtocolExporterRule> rules) {
        return new TextProtocolExporterVisitor(journal, os, rules);
    }

    public void register(TextProtocolExporterRule rule) {
        this._rules.add(rule);
    }

    public void unregister(TextProtocolExporterRule rule) {
        this._rules.remove(rule);
    }
}

