/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.validation;

import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Logger;

public class Scope {
    private static final Logger LOG = Logger.getLogger(Scope.class.getName());
    private List<Map<String, Object>> _stateStack = new Vector<Map<String, Object>>();

    public Scope() {
        this.pushState();
    }

    public Scope(Scope copy) {
        for (int i = 0; i < copy._stateStack.size(); ++i) {
            Map<String, Object> current = copy._stateStack.get(i);
            Hashtable<String, Object> copyStackEntry = new Hashtable<String, Object>();
            for (String key : current.keySet()) {
                Object value = current.get(key);
                copyStackEntry.put(key, value);
            }
            this._stateStack.add(copyStackEntry);
        }
    }

    public Object getState(String name) {
        Object ret = null;
        if (this._stateStack.size() > 0) {
            for (int i = 0; ret == null && i < this._stateStack.size(); ++i) {
                Map<String, Object> current = this._stateStack.get(i);
                ret = current.get(name);
            }
        }
        return ret;
    }

    public void setState(String name, Object value) {
        if (this._stateStack.size() > 0) {
            Map<String, Object> current = this._stateStack.get(0);
            current.put(name, value);
        }
    }

    public void pushState() {
        this._stateStack.add(0, new Hashtable());
    }

    public void popState() {
        if (this._stateStack.size() > 0) {
            this._stateStack.remove(0);
        } else {
            LOG.severe("No state entry to pop from stack");
        }
    }
}

