/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.validation.rules;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.PropertyResourceBundle;
import java.util.Set;
import java.util.Vector;
import org.scribble.common.logging.Journal;
import org.scribble.protocol.model.Block;
import org.scribble.protocol.model.Choice;
import org.scribble.protocol.model.ModelObject;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.util.InteractionUtil;
import org.scribble.protocol.util.RoleUtil;
import org.scribble.protocol.validation.ProtocolComponentValidatorRule;
import org.scribble.protocol.validation.ProtocolValidatorContext;

public class ChoiceValidatorRule
implements ProtocolComponentValidatorRule {
    public boolean isSupported(ModelObject obj) {
        return obj.getClass() == Choice.class;
    }

    public void validate(ProtocolValidatorContext pvc, ModelObject obj, Journal logger) {
        Set<Role> roles;
        Choice elem = (Choice)obj;
        Role locatedRole = null;
        if (elem.getEnclosingProtocol() != null) {
            locatedRole = elem.getEnclosingProtocol().getLocatedRole();
        }
        if (elem.getRole() != null && !(roles = RoleUtil.getRolesInScope(elem)).contains(elem.getRole())) {
            logger.error(MessageFormat.format(PropertyResourceBundle.getBundle("org.scribble.protocol.Messages").getString("_UNKNOWN_ROLE"), elem.getRole().getName()), obj.getProperties());
        }
        if (locatedRole != null && elem.getRole() != null && !elem.getRole().equals(locatedRole)) {
            logger.error(MessageFormat.format(PropertyResourceBundle.getBundle("org.scribble.protocol.Messages").getString("_UNRELATED_TO_LOCATED_ROLE"), locatedRole.getName()), obj.getProperties());
        }
        ChoiceValidatorRule.checkForAmbiguity(elem, logger);
    }

    protected static void checkForAmbiguity(Choice choice, Journal l) {
        Vector<ModelObject> interactions = new Vector<ModelObject>();
        for (Block path : choice.getPaths()) {
            List<ModelObject> initial = InteractionUtil.getInitialInteractions(path);
            if (!Collections.disjoint(interactions, initial)) {
                l.error(MessageFormat.format(PropertyResourceBundle.getBundle("org.scribble.protocol.Messages").getString("_AMBIGUOUS_CHOICE"), initial), choice.getProperties());
                continue;
            }
            interactions.addAll(initial);
        }
    }
}

