/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.model;

import java.util.List;
import org.scribble.protocol.model.ContainmentList;
import org.scribble.protocol.model.FullyQualifiedName;
import org.scribble.protocol.model.ImportDecl;
import org.scribble.protocol.model.ModelObject;
import org.scribble.protocol.model.PayloadTypeDecl;
import org.scribble.protocol.model.Protocol;
import org.scribble.protocol.model.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Module
extends ModelObject {
    private FullyQualifiedName _package = null;
    private List<ImportDecl> _imports = new ContainmentList<ImportDecl>(this, ImportDecl.class);
    private List<PayloadTypeDecl> _payloadTypes = new ContainmentList<PayloadTypeDecl>(this, PayloadTypeDecl.class);
    private List<Protocol> _protocols = new ContainmentList<Protocol>(this, Protocol.class);

    public FullyQualifiedName getPackage() {
        return this._package;
    }

    public void setPackage(FullyQualifiedName pn) {
        this._package = pn;
    }

    public List<ImportDecl> getImports() {
        return this._imports;
    }

    public List<PayloadTypeDecl> getTypeDeclarations() {
        return this._payloadTypes;
    }

    public PayloadTypeDecl getTypeDeclaration(String name) {
        for (PayloadTypeDecl ptd : this._payloadTypes) {
            if (ptd.getAlias() == null || !ptd.getAlias().equals(name)) continue;
            return ptd;
        }
        return null;
    }

    public List<Protocol> getProtocols() {
        return this._protocols;
    }

    public Protocol getProtocol(String name) {
        for (Protocol p : this._protocols) {
            if (!p.getName().equals(name)) continue;
            return p;
        }
        return null;
    }

    @Override
    public void visit(Visitor visitor) {
        for (ImportDecl imp : this.getImports()) {
            imp.visit(visitor);
        }
        for (PayloadTypeDecl ptd : this.getTypeDeclarations()) {
            ptd.visit(visitor);
        }
        for (Protocol protocol : this.getProtocols()) {
            protocol.visit(visitor);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        this.toText(buf, 0);
        return buf.toString();
    }

    @Override
    public void toText(StringBuffer buf, int level) {
        if (this._package != null) {
            this.indent(buf, level);
            buf.append("package ");
            this._package.toText(buf, level);
            buf.append(";\n\n");
        }
        for (ImportDecl imp : this.getImports()) {
            imp.toText(buf, level);
        }
        if (this.getImports().size() > 0) {
            buf.append("\n");
        }
        for (PayloadTypeDecl ptd : this.getTypeDeclarations()) {
            ptd.toText(buf, level);
        }
        if (this.getTypeDeclarations().size() > 0) {
            buf.append("\n");
        }
        for (Protocol protocol : this.getProtocols()) {
            protocol.toText(buf, level);
        }
    }
}

