/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.model.global;

import java.util.List;
import org.scribble.protocol.model.ContainmentList;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.model.global.GActivity;
import org.scribble.protocol.model.global.GBlock;
import org.scribble.protocol.model.global.GVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GChoice
extends GActivity {
    private Role _role = null;
    private List<GBlock> _blocks = new ContainmentList<GBlock>(this, GBlock.class);

    public Role getRole() {
        return this._role;
    }

    public void setRole(Role role) {
        this._role = role;
    }

    public List<GBlock> getPaths() {
        return this._blocks;
    }

    @Override
    public void visit(GVisitor visitor) {
        if (visitor.start(this)) {
            for (GBlock b : this.getPaths()) {
                b.visit(visitor);
            }
        }
        visitor.end(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GChoice that = (GChoice)o;
        return !(this._role == null ? that._role != null : !this._role.equals(that._role)) && this._blocks.equals(that._blocks);
    }

    public int hashCode() {
        int result = this._blocks.hashCode();
        result = 31 * result + (this._role != null ? this._role.hashCode() : 0);
        return result;
    }

    public String toString() {
        String result = "choice ";
        if (this._role != null) {
            result = result + "at " + this._role + " ";
        }
        for (GBlock b : this._blocks) {
            if (this._blocks.indexOf(b) > 0) {
                result = result + "or ";
            }
            result = result + b + "\n";
        }
        return result;
    }

    @Override
    public void toText(StringBuffer buf, int level) {
        this.indent(buf, level);
        buf.append("choice at ");
        if (this._role != null) {
            buf.append(this._role);
            buf.append(" ");
        }
        for (int i = 0; i < this.getPaths().size(); ++i) {
            if (i > 0) {
                buf.append(" or ");
            }
            this.getPaths().get(i).toText(buf, level);
        }
        buf.append("\n");
    }
}

