/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.model.global;

import org.scribble.protocol.model.Protocol;
import org.scribble.protocol.model.RoleDefn;
import org.scribble.protocol.model.Visitor;
import org.scribble.protocol.model.global.GBlock;
import org.scribble.protocol.model.global.GVisitor;

public class GProtocol
extends Protocol {
    private GBlock _block = null;

    public GBlock getBlock() {
        if (this._block == null) {
            this._block = new GBlock();
            this._block.setParent(this);
        }
        return this._block;
    }

    public void setBlock(GBlock block) {
        if (this._block != null) {
            this._block.setParent(null);
        }
        this._block = block;
        if (this._block != null) {
            this._block.setParent(this);
        }
    }

    public void visit(Visitor visitor) {
        if (visitor instanceof GVisitor) {
            if (((GVisitor)visitor).start(this) && this.getBlock() != null) {
                this.getBlock().visit(visitor);
            }
            ((GVisitor)visitor).end(this);
        }
    }

    public String toString() {
        String ret = "global protocol " + this.getName() + " ( ";
        for (RoleDefn role : this.getRoleDefinitions()) {
            ret = ret + "role " + role.getName() + " ";
        }
        ret = ret + ")\n";
        ret = ret + this.getBlock();
        return ret;
    }

    public void toText(StringBuffer buf, int level) {
        this.indent(buf, level);
        buf.append("global protocol ");
        buf.append(this.getName());
        buf.append("(");
        for (int i = 0; i < this.getRoleDefinitions().size(); ++i) {
            if (i > 0) {
                buf.append(",");
            }
            buf.append("role ");
            this.getRoleDefinitions().get(i).toText(buf, level);
        }
        buf.append(") ");
        if (this._block != null) {
            this._block.toText(buf, level);
        }
        buf.append("\n");
    }
}

