/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.model.local;

import org.scribble.protocol.model.Protocol;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.model.RoleDefn;
import org.scribble.protocol.model.Visitor;
import org.scribble.protocol.model.local.LBlock;
import org.scribble.protocol.model.local.LVisitor;

public class LProtocol
extends Protocol {
    private Role _localRole = null;
    private LBlock _block = null;

    public Role getLocalRole() {
        return this._localRole;
    }

    public void setLocalRole(Role role) {
        this._localRole = role;
    }

    public LBlock getBlock() {
        if (this._block == null) {
            this._block = new LBlock();
            this._block.setParent(this);
        }
        return this._block;
    }

    public void setBlock(LBlock block) {
        if (this._block != null) {
            this._block.setParent(null);
        }
        this._block = block;
        if (this._block != null) {
            this._block.setParent(this);
        }
    }

    public void visit(Visitor visitor) {
        if (visitor instanceof LVisitor) {
            if (((LVisitor)visitor).start(this) && this.getBlock() != null) {
                this.getBlock().visit(visitor);
            }
            ((LVisitor)visitor).end(this);
        }
    }

    public String toString() {
        String ret = "local protocol " + this.getName() + " ( ";
        for (RoleDefn role : this.getRoleDefinitions()) {
            ret = ret + "role " + role.getName() + " ";
        }
        ret = ret + ")\n";
        ret = ret + this.getBlock();
        return ret;
    }

    public void toText(StringBuffer buf, int level) {
        this.indent(buf, level);
        buf.append("local protocol ");
        buf.append(this.getName());
        buf.append(" at ");
        if (this._localRole != null) {
            this._localRole.toText(buf, level);
        }
        buf.append("(");
        for (int i = 0; i < this.getRoleDefinitions().size(); ++i) {
            if (i > 0) {
                buf.append(",");
            }
            buf.append("role ");
            this.getRoleDefinitions().get(i).toText(buf, level);
        }
        buf.append(") ");
        if (this._block != null) {
            this._block.toText(buf, level);
        }
        buf.append("\n");
    }
}

