/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.scribble.protocol.model.ModelObject;
import org.scribble.protocol.model.Module;
import org.scribble.protocol.parser.ParserLogger;
import org.scribble.protocol.parser.ResourceLocator;
import org.scribble.protocol.parser.antlr.ProtocolTreeAdaptor;
import org.scribble.protocol.parser.antlr.ScribbleProtocolLexer;
import org.scribble.protocol.parser.antlr.ScribbleProtocolParser;
import org.scribble.protocol.validation.ComponentLoader;
import org.scribble.protocol.validation.DefaultValidationContext;
import org.scribble.protocol.validation.ProtocolValidator;
import org.scribble.protocol.validation.ValidationContext;
import org.scribble.protocol.validation.ValidationLogger;

public class ProtocolParser {
    private static final Logger LOG = Logger.getLogger(ProtocolParser.class.getName());

    public Module parse(InputStream is, final ResourceLocator locator, final ParserLogger logger) throws IOException {
        Module ret = null;
        try {
            byte[] b = new byte[is.available()];
            is.read(b);
            is.close();
            String document = new String(b);
            ScribbleProtocolLexer lex = new ScribbleProtocolLexer((CharStream)new ANTLRStringStream(document));
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lex);
            ScribbleProtocolParser parser = new ScribbleProtocolParser((TokenStream)tokens);
            ProtocolTreeAdaptor adaptor = new ProtocolTreeAdaptor();
            adaptor.setParser(parser);
            parser.setDocument(document);
            parser.setTreeAdaptor(adaptor);
            parser.setParserLogger(logger);
            parser.module();
            if (!parser.isErrorOccurred()) {
                ret = adaptor.getModule();
                ProtocolValidator pv = new ProtocolValidator();
                DefaultValidationContext context = new DefaultValidationContext(new ComponentLoader(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Module loadModule(String module) {
                        Module ret = null;
                        InputStream is = locator.getModule(module);
                        if (is != null) {
                            try {
                                ret = ProtocolParser.this.parse(is, locator, logger);
                            }
                            catch (Exception e) {
                                LOG.log(Level.SEVERE, "Failed to parse imported module '" + module + "'", e);
                            }
                            finally {
                                try {
                                    is.close();
                                }
                                catch (Exception e) {
                                    LOG.log(Level.SEVERE, "Failed to close input stream", e);
                                }
                            }
                        }
                        return ret;
                    }
                });
                pv.validate((ValidationContext)context, ret, new ValidationLogger(){

                    public void error(String issue, ModelObject mobj) {
                        logger.error(issue, mobj.getProperties());
                    }

                    public void warning(String issue, ModelObject mobj) {
                        logger.warning(issue, mobj.getProperties());
                    }

                    public void info(String issue, ModelObject mobj) {
                        logger.info(issue, mobj.getProperties());
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }
}

