/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.monitor.model;

import java.util.ArrayList;
import java.util.List;
import org.scribble.monitor.SessionScope;
import org.scribble.monitor.model.Node;
import org.scribble.monitor.model.SessionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parallel
extends Node {
    private List<Integer> _pathIndexes = new ArrayList<Integer>();

    public List<Integer> getPathIndexes() {
        return this._pathIndexes;
    }

    public void getPathIndexes(List<Integer> indexes) {
        this._pathIndexes = indexes;
    }

    @Override
    public boolean evaluate(SessionType type, int index, SessionScope scope) {
        SessionScope parallelScope = new SessionScope();
        parallelScope.setName("Parallel/" + index);
        for (int i = 0; i < this._pathIndexes.size(); ++i) {
            SessionScope sub = new SessionScope();
            if (Node._nameSessions) {
                sub.setName("Parallel/" + index + "/" + i);
            }
            int subIndex = this._pathIndexes.get(i);
            Node nextNode = type.getNode(this._pathIndexes.get(i));
            nextNode.evaluate(type, subIndex, sub);
            if (sub.completed()) continue;
            parallelScope.addSubScope(sub);
        }
        if (!parallelScope.completed()) {
            parallelScope.setCompletionIndex(this.getNext());
            scope.addSubScope(parallelScope);
        }
        return parallelScope.completed();
    }
}

