/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.monitor.export.rules;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public class ExportState {
    private Stack<StateInformation> _state = new Stack();

    public void push() {
        this._state.push(new StateInformation());
    }

    public void pop() {
        this._state.pop();
    }

    public void registerLabelIndex(String label, int index) {
        this._state.peek().registerLabelIndex(label, index);
    }

    public void unregisterLabel(String label) {
        this._state.peek().unregisterLabel(label);
    }

    public int getLabelIndex(String label) {
        int ret = -1;
        for (int i = this._state.size() - 1; ret == -1 && i >= 0; --i) {
            ret = ((StateInformation)this._state.get(i)).getLabelIndex(label);
        }
        return ret;
    }

    public static class StateInformation {
        private Map<String, Integer> _labelIndexes = new HashMap<String, Integer>();

        public void registerLabelIndex(String label, int index) {
            this._labelIndexes.put(label, index);
        }

        public void unregisterLabel(String label) {
            this._labelIndexes.remove(label);
        }

        public int getLabelIndex(String label) {
            if (this._labelIndexes.containsKey(label)) {
                return this._labelIndexes.get(label);
            }
            return -1;
        }
    }
}

