/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.projection.rules;

import java.util.HashSet;
import org.scribble.context.ModuleContext;
import org.scribble.logging.IssueLogger;
import org.scribble.model.Message;
import org.scribble.model.ModelObject;
import org.scribble.model.Role;
import org.scribble.model.RoleDecl;
import org.scribble.model.global.GInterruptible;
import org.scribble.model.local.LBlock;
import org.scribble.model.local.LInterruptible;
import org.scribble.projection.rules.ProjectionRule;
import org.scribble.projection.rules.ProjectionRuleFactory;

public class GInterruptibleProjectionRule
implements ProjectionRule {
    public Object project(ModuleContext context, ModelObject mobj, RoleDecl role, IssueLogger logger) {
        LInterruptible projected = null;
        GInterruptible source = (GInterruptible)mobj;
        if (source.isRoleInvolved(role)) {
            Message lm;
            LBlock lb;
            projected = new LInterruptible();
            projected.derivedFrom((ModelObject)source);
            projected.setScope(source.getScope());
            ProjectionRule rule = ProjectionRuleFactory.getProjectionRule((ModelObject)source.getBlock());
            if (rule != null && (lb = (LBlock)rule.project(context, (ModelObject)source.getBlock(), role, logger)) != null) {
                projected.setBlock(lb);
            }
            HashSet roles = new HashSet();
            source.identifyInvolvedRoles(roles);
            for (GInterruptible.Interrupt i : source.getInterrupts()) {
                if (!role.isRole(i.getRole())) continue;
                LInterruptible.Throw lt = new LInterruptible.Throw();
                for (Message m : i.getMessages()) {
                    lm = new Message(m);
                    lt.getMessages().add(lm);
                }
                for (Role r : roles) {
                    if (role.isRole(r)) continue;
                    lt.getToRoles().add(new Role(r));
                }
                projected.setThrows(lt);
                break;
            }
            for (GInterruptible.Interrupt i : source.getInterrupts()) {
                if (role.isRole(i.getRole())) continue;
                LInterruptible.Catch lc = new LInterruptible.Catch();
                for (Message m : i.getMessages()) {
                    lm = new Message(m);
                    lc.getMessages().add(lm);
                }
                lc.setRole(new Role(i.getRole()));
                projected.getCatches().add(lc);
            }
        }
        return projected;
    }
}

