/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.projection.rules;

import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import org.scribble.context.ModuleContext;
import org.scribble.logging.IssueLogger;
import org.scribble.model.ModelObject;
import org.scribble.model.Role;
import org.scribble.model.RoleDecl;
import org.scribble.model.global.GChoice;
import org.scribble.model.local.LActivity;
import org.scribble.model.local.LBlock;
import org.scribble.model.local.LChoice;
import org.scribble.projection.rules.ProjectionRule;
import org.scribble.projection.rules.ProjectionRuleFactory;

public class GChoiceProjectionRule
implements ProjectionRule {
    private static final Logger LOG = Logger.getLogger(GChoiceProjectionRule.class.getName());

    @Override
    public Object project(ModuleContext context, ModelObject mobj, RoleDecl role, IssueLogger logger) {
        LChoice projected = new LChoice();
        GChoice source = (GChoice)mobj;
        projected.derivedFrom((ModelObject)source);
        projected.setRole(new Role(source.getRole()));
        boolean f_missingBranch = false;
        for (int i = 0; i < source.getPaths().size(); ++i) {
            ProjectionRule rule = ProjectionRuleFactory.getProjectionRule((ModelObject)source.getPaths().get(i));
            if (rule == null) continue;
            LBlock block = (LBlock)rule.project(context, (ModelObject)source.getPaths().get(i), role, logger);
            if (block != null) {
                if (block.getContents().size() == 1 && block.getContents().get(0) instanceof LChoice && this.isSameRole(projected, (LChoice)block.getContents().get(0))) {
                    projected.getPaths().addAll(((LChoice)block.getContents().get(0)).getPaths());
                    continue;
                }
                projected.getPaths().add(block);
                continue;
            }
            f_missingBranch = true;
        }
        if (f_missingBranch && projected.getPaths().size() <= 0) {
            return null;
        }
        return GChoiceProjectionRule.merge(projected, role, logger);
    }

    protected boolean isSameRole(LChoice c1, LChoice c2) {
        if (c1.getRole() == null && c2.getRole() == null) {
            return true;
        }
        if (c1.getRole() == null || c2.getRole() == null) {
            return false;
        }
        return c1.getRole().equals((Object)c2.getRole());
    }

    protected static Object merge(LChoice projected, RoleDecl role, IssueLogger l) {
        Object ret = null;
        ret = GChoiceProjectionRule.extractCommonBehaviour(projected, role, l);
        GChoiceProjectionRule.groupSubpathsWithCommonInitiator(projected, role, l);
        for (int i = projected.getPaths().size() - 1; i >= 0; --i) {
            LBlock b = (LBlock)projected.getPaths().get(i);
            if (b.size() != 0) continue;
            projected.getPaths().remove(i);
        }
        if (projected.getPaths().size() == 0) {
            if (ret == projected) {
                ret = null;
            } else {
                ((List)ret).remove(projected);
            }
            projected = null;
        }
        return ret;
    }

    protected static void groupSubpathsWithCommonInitiator(LChoice projected, RoleDecl role, IssueLogger l) {
        List<Object> plist;
        HashMap<LActivity, Vector<LBlock>> pathGroups = new HashMap<LActivity, Vector<LBlock>>();
        for (LBlock path : projected.getPaths()) {
            if (path.size() <= 0) continue;
            plist = (Vector<LBlock>)pathGroups.get(path.get(0));
            if (plist == null) {
                plist = new Vector<LBlock>();
                pathGroups.put(path.get(0), (Vector<LBlock>)plist);
            }
            plist.add(path);
        }
        for (LActivity act : pathGroups.keySet()) {
            plist = (List)pathGroups.get(act);
            if (plist.size() < 2) continue;
            LChoice sub = new LChoice();
            int pos = -1;
            for (LBlock b : plist) {
                if (pos == -1) {
                    pos = projected.getPaths().indexOf(b);
                }
                projected.getPaths().remove(b);
                sub.getPaths().add(b);
            }
            LBlock newPath = new LBlock();
            projected.getPaths().add(pos, newPath);
            Object processed = GChoiceProjectionRule.merge(sub, role, l);
            if (processed instanceof List) {
                newPath.getContents().addAll((List)processed);
                continue;
            }
            LOG.severe("Should have returned a list with extracted common activity(s) followed by choice");
        }
    }

    protected static Object extractCommonBehaviour(LChoice projected, RoleDecl role, IssueLogger l) {
        Object ret = projected;
        boolean checkPaths = true;
        do {
            int i;
            boolean allSame = projected.getPaths().size() > 1;
            for (i = 1; allSame && i < projected.getPaths().size(); ++i) {
                LBlock b1 = (LBlock)projected.getPaths().get(0);
                LBlock b2 = (LBlock)projected.getPaths().get(i);
                if (b1.size() == 0 || b2.size() == 0) {
                    allSame = false;
                    continue;
                }
                if (b1.get(0).equals(b2.get(0))) continue;
                allSame = false;
            }
            if (allSame) {
                if (!(ret instanceof List)) {
                    ret = new Vector();
                    ((List)ret).add(projected);
                }
                ((List)ret).add(((List)ret).size() - 1, ((LBlock)projected.getPaths().get(0)).getContents().get(0));
                for (i = 0; i < projected.getPaths().size(); ++i) {
                    ((LBlock)projected.getPaths().get(i)).getContents().remove(0);
                }
            } else {
                checkPaths = false;
            }
        } while (checkPaths);
        return ret;
    }
}

