/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.validation.rules;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.scribble.common.logging.ScribbleLogger;
import org.scribble.common.module.ModuleContext;
import org.scribble.model.ModelObject;
import org.scribble.model.Role;
import org.scribble.model.global.GActivity;
import org.scribble.model.global.GBlock;
import org.scribble.model.global.GChoice;
import org.scribble.model.global.GMessageTransfer;
import org.scribble.model.global.GMultiPathActivity;
import org.scribble.model.global.GProtocolDefinition;
import org.scribble.model.global.GSinglePathActivity;
import org.scribble.validation.ValidationMessages;
import org.scribble.validation.rules.ValidationRule;
import org.scribble.validation.rules.ValidationRuleFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GChoiceValidationRule
implements ValidationRule {
    @Override
    public void validate(ModuleContext context, ModelObject mobj, ScribbleLogger logger) {
        GChoice elem = (GChoice)mobj;
        if (elem.getRole() != null) {
            GProtocolDefinition gpd = (GProtocolDefinition)elem.getParent(GProtocolDefinition.class);
            if (gpd.getRoleDeclaration(elem.getRole().getName()) == null) {
                logger.error(MessageFormat.format(ValidationMessages.getMessage("UNKNOWN_ROLE"), elem.getRole().getName()), (ModelObject)elem.getRole());
            }
        } else {
            logger.error(ValidationMessages.getMessage("UNDEFINED_ROLE"), (ModelObject)elem);
        }
        HashSet roles = null;
        for (GBlock subelem : elem.getPaths()) {
            ValidationRule rule = ValidationRuleFactory.getValidationRule((ModelObject)subelem);
            if (rule != null) {
                rule.validate(context, (ModelObject)subelem, logger);
            }
            HashSet subroles = new HashSet();
            subelem.identifyInvolvedRoles(subroles);
            if (roles == null) {
                roles = subroles;
                continue;
            }
            if (roles.equals(subroles)) continue;
            logger.error(ValidationMessages.getMessage("ROLES_MISMATCH"), (ModelObject)elem.getRole());
        }
        if (roles != null) {
            HashSet otherRoles = new HashSet(roles);
            otherRoles.remove(elem.getRole());
            for (GBlock block : elem.getPaths()) {
                this.checkReceiverBeforeOtherActivity(context, block, new HashSet<Role>(otherRoles), logger);
            }
            HashMap<Role, Set<String>> ops = new HashMap<Role, Set<String>>();
            HashMap<Role, Set<String>> sigs = new HashMap<Role, Set<String>>();
            for (GBlock block : elem.getPaths()) {
                this.checkReceiverOpSigDistinct(context, block, new HashSet<Role>(otherRoles), ops, sigs, logger);
            }
        }
    }

    protected void checkReceiverBeforeOtherActivity(ModuleContext context, GBlock block, Set<Role> roles, ScribbleLogger logger) {
        for (GActivity act : block.getContents()) {
            if (act instanceof GMessageTransfer) {
                roles.removeAll(((GMessageTransfer)act).getToRoles());
                if (!roles.contains(((GMessageTransfer)act).getFromRole())) continue;
                logger.error(MessageFormat.format(ValidationMessages.getMessage("ROLE_NOT_RECEIVER"), ((GMessageTransfer)act).getFromRole().getName()), (ModelObject)act);
                roles.remove(((GMessageTransfer)act).getFromRole());
                continue;
            }
            if (act instanceof GChoice) {
                if (roles.contains(((GChoice)act).getRole())) {
                    logger.error(MessageFormat.format(ValidationMessages.getMessage("ROLE_NOT_RECEIVER"), ((GChoice)act).getRole().getName()), (ModelObject)act);
                    roles.remove(((GChoice)act).getRole());
                }
                for (GBlock b : ((GChoice)act).getPaths()) {
                    this.checkReceiverBeforeOtherActivity(context, b, new HashSet<Role>(roles), logger);
                }
                continue;
            }
            if (act instanceof GMultiPathActivity) {
                for (GBlock b : ((GMultiPathActivity)act).getPaths()) {
                    this.checkReceiverBeforeOtherActivity(context, b, new HashSet<Role>(roles), logger);
                }
                continue;
            }
            if (act instanceof GSinglePathActivity) {
                this.checkReceiverBeforeOtherActivity(context, ((GSinglePathActivity)act).getBlock(), roles, logger);
                continue;
            }
            HashSet involved = new HashSet();
            act.identifyInvolvedRoles(involved);
            for (Role r : involved) {
                if (!roles.contains(r)) continue;
                logger.error(MessageFormat.format(ValidationMessages.getMessage("ROLE_NOT_RECEIVER"), r.getName()), (ModelObject)act);
                roles.remove(r);
            }
        }
    }

    protected void checkReceiverOpSigDistinct(ModuleContext context, GBlock block, Set<Role> roles, Map<Role, Set<String>> operators, Map<Role, Set<String>> signatures, ScribbleLogger logger) {
        for (int i = 0; roles.size() > 0 && i < block.getContents().size(); ++i) {
            GActivity act = (GActivity)block.getContents().get(i);
            if (act instanceof GMessageTransfer) {
                for (Role r : ((GMessageTransfer)act).getToRoles()) {
                    GMessageTransfer mt;
                    if (!roles.contains(r) || (mt = (GMessageTransfer)act).getMessage() == null) continue;
                    if (mt.getMessage().getMessageSignature() != null && mt.getMessage().getMessageSignature().getOperator() != null) {
                        Set<String> ops = operators.get(r);
                        if (ops == null) {
                            ops = new HashSet<String>();
                            operators.put(r, ops);
                        }
                        if (ops.contains(mt.getMessage().getMessageSignature().getOperator())) {
                            logger.error(MessageFormat.format(ValidationMessages.getMessage("ROLE_OPERATOR_NOT_DISTINCT"), mt.getMessage().getMessageSignature().getOperator(), r.getName()), (ModelObject)act);
                        }
                        ops.add(mt.getMessage().getMessageSignature().getOperator());
                    } else if (mt.getMessage().getParameter() != null) {
                        Set<String> sigs = signatures.get(r);
                        if (sigs == null) {
                            sigs = new HashSet<String>();
                            signatures.put(r, sigs);
                        }
                        if (sigs.contains(mt.getMessage().getParameter())) {
                            logger.error(MessageFormat.format(ValidationMessages.getMessage("ROLE_SIGNATURE_NOT_DISTINCT"), mt.getMessage().getParameter(), r.getName()), (ModelObject)act);
                        }
                        sigs.add(mt.getMessage().getParameter());
                    }
                    roles.remove(r);
                }
                continue;
            }
            if (act instanceof GMultiPathActivity) {
                for (GBlock b : ((GMultiPathActivity)act).getPaths()) {
                    this.checkReceiverOpSigDistinct(context, b, new HashSet<Role>(roles), operators, signatures, logger);
                }
                continue;
            }
            if (!(act instanceof GSinglePathActivity)) continue;
            this.checkReceiverOpSigDistinct(context, ((GSinglePathActivity)act).getBlock(), roles, operators, signatures, logger);
        }
    }
}

