/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.validation.rules;

import java.text.MessageFormat;
import org.scribble.common.logging.ScribbleLogger;
import org.scribble.common.module.ModuleContext;
import org.scribble.model.Message;
import org.scribble.model.ModelObject;
import org.scribble.model.ProtocolDecl;
import org.scribble.model.Role;
import org.scribble.model.local.LInterruptible;
import org.scribble.validation.ValidationMessages;
import org.scribble.validation.rules.MessageValidationRule;
import org.scribble.validation.rules.ValidationRule;
import org.scribble.validation.rules.ValidationRuleFactory;

public class LInterruptibleValidationRule
implements ValidationRule {
    public void validate(ModuleContext context, ModelObject mobj, ScribbleLogger logger) {
        ValidationRule rule;
        LInterruptible elem = (LInterruptible)mobj;
        ProtocolDecl pd = (ProtocolDecl)elem.getParent(ProtocolDecl.class);
        MessageValidationRule mvr = new MessageValidationRule();
        if (elem.getThrows() != null) {
            for (Message m : elem.getThrows().getMessages()) {
                mvr.validate(context, (ModelObject)m, logger);
            }
            if (pd != null) {
                for (Role r : elem.getThrows().getToRoles()) {
                    if (pd.getRoleDeclaration(r.getName()) != null) continue;
                    logger.error(MessageFormat.format(ValidationMessages.getMessage("UNKNOWN_ROLE"), r.getName()), (ModelObject)r);
                }
            }
        }
        for (LInterruptible.Catch cat : elem.getCatches()) {
            for (Message m : cat.getMessages()) {
                mvr.validate(context, (ModelObject)m, logger);
            }
            if (pd == null || cat.getRole() == null || pd.getRoleDeclaration(cat.getRole().getName()) != null) continue;
            logger.error(MessageFormat.format(ValidationMessages.getMessage("UNKNOWN_ROLE"), cat.getRole().getName()), (ModelObject)cat.getRole());
        }
        if (elem.getBlock() != null && (rule = ValidationRuleFactory.getValidationRule((ModelObject)elem.getBlock())) != null) {
            rule.validate(context, (ModelObject)elem.getBlock(), logger);
        }
    }
}

