/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.validation.rules;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.scribble.common.logging.ScribbleLogger;
import org.scribble.common.module.ModuleContext;
import org.scribble.model.Argument;
import org.scribble.model.ModelObject;
import org.scribble.model.Module;
import org.scribble.model.PayloadTypeDecl;
import org.scribble.model.RoleInstantiation;
import org.scribble.model.global.GProtocolDefinition;
import org.scribble.model.global.GProtocolInstance;
import org.scribble.validation.ValidationMessages;
import org.scribble.validation.rules.ValidationRule;
import org.scribble.validation.rules.ValidationRuleFactory;

public class GProtocolInstanceValidationRule
implements ValidationRule {
    public void validate(ModuleContext context, ModelObject mobj, ScribbleLogger logger) {
        GProtocolInstance elem = (GProtocolInstance)mobj;
        if (elem.getMemberName() != null) {
            ModelObject refd = context.getMember(elem.getMemberName());
            if (refd == null) {
                logger.error(MessageFormat.format(ValidationMessages.getMessage("UNKNOWN_MEMBER_NAME"), elem.getMemberName()), (ModelObject)elem);
            } else if (!(refd instanceof GProtocolDefinition)) {
                logger.error(MessageFormat.format(ValidationMessages.getMessage("MEMBER_NOT_PROTOCOL_DEFINITION"), elem.getMemberName()), (ModelObject)elem);
            } else {
                GProtocolDefinition pd = (GProtocolDefinition)refd;
                if (pd.getParameterDeclarations().size() != elem.getArguments().size()) {
                    logger.error(MessageFormat.format(ValidationMessages.getMessage("ARG_NUM_MISMATCH"), elem.getArguments().size(), pd.getParameterDeclarations().size()), (ModelObject)elem);
                }
                for (Argument arg : elem.getArguments()) {
                    if (arg.getMessageSignature() != null) {
                        ValidationRule rule = ValidationRuleFactory.getValidationRule((ModelObject)arg.getMessageSignature());
                        if (rule != null) {
                            rule.validate(context, (ModelObject)arg.getMessageSignature(), logger);
                        }
                    } else if (arg.getName() != null) {
                        ModelObject impmem;
                        Module m = elem.getModule();
                        PayloadTypeDecl ptd = null;
                        if (m != null) {
                            ptd = m.getTypeDeclaration(arg.getName());
                        }
                        if (ptd == null && (impmem = context.getImportedMember(arg.getName())) instanceof PayloadTypeDecl) {
                            ptd = (PayloadTypeDecl)impmem;
                        }
                        if (ptd == null && elem.getParameterDeclaration(arg.getName()) == null) {
                            logger.error(MessageFormat.format(ValidationMessages.getMessage("ARG_NOT_DECLARED"), arg.getName()), (ModelObject)elem);
                        }
                    }
                    if (arg.getAlias() == null || pd.getParameterDeclaration(arg.getAlias()) != null) continue;
                    logger.error(MessageFormat.format(ValidationMessages.getMessage("ARG_ALIAS_NOT_DECLARED"), arg.getAlias()), (ModelObject)elem);
                }
                if (pd.getRoleDeclarations().size() != elem.getRoleInstantiations().size()) {
                    logger.error(MessageFormat.format(ValidationMessages.getMessage("ROLE_NUM_MISMATCH"), elem.getRoleInstantiations().size(), pd.getRoleDeclarations().size()), (ModelObject)elem);
                }
                ArrayList<String> roleNames = new ArrayList<String>();
                for (RoleInstantiation ri : elem.getRoleInstantiations()) {
                    if (ri.getName() != null) {
                        if (elem.getRoleDeclaration(ri.getName()) == null) {
                            logger.error(MessageFormat.format(ValidationMessages.getMessage("ROLE_NOT_DECLARED"), ri.getName()), (ModelObject)elem);
                        }
                        if (roleNames.contains(ri.getName())) {
                            logger.error(MessageFormat.format(ValidationMessages.getMessage("ROLE_NOT_DISTINCT"), ri.getName()), (ModelObject)elem);
                        } else {
                            roleNames.add(ri.getName());
                        }
                    }
                    if (ri.getAlias() == null || pd.getRoleDeclaration(ri.getAlias()) != null) continue;
                    logger.error(MessageFormat.format(ValidationMessages.getMessage("ROLE_ALIAS_NOT_DECLARED"), ri.getAlias()), (ModelObject)elem);
                }
            }
        }
    }
}

