/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.validation.rules;

import java.text.MessageFormat;
import org.scribble.common.logging.ScribbleLogger;
import org.scribble.common.module.ModuleContext;
import org.scribble.model.ImportDecl;
import org.scribble.model.ModelObject;
import org.scribble.model.Module;
import org.scribble.validation.ValidationMessages;
import org.scribble.validation.rules.ValidationRule;

public class ImportDeclValidationRule
implements ValidationRule {
    public void validate(ModuleContext context, ModelObject mobj, ScribbleLogger logger) {
        ImportDecl elem = (ImportDecl)mobj;
        if (elem.getModuleName() != null) {
            Module importedModule = context.importModule(elem.getModuleName().getName());
            if (importedModule == null) {
                logger.error(MessageFormat.format(ValidationMessages.getMessage("NOT_FOUND_MODULE"), elem.getModuleName().getName()), (ModelObject)elem);
            } else if (elem.getMemberName() != null) {
                if (elem.getAlias() == null && context.getMember(elem.getModuleName().getName(), elem.getMemberName()) == null) {
                    logger.error(MessageFormat.format(ValidationMessages.getMessage("NOT_FOUND_MEMBER"), elem.getMemberName(), elem.getModuleName().getName()), (ModelObject)elem);
                } else if (context.getImportedMember(elem.getAlias()) != null) {
                    logger.error(MessageFormat.format(ValidationMessages.getMessage("EXISTS_ALIAS"), elem.getAlias()), (ModelObject)elem);
                } else if (context.registerImportedMember(elem.getModuleName().getName(), elem.getMemberName(), elem.getAlias()) == null) {
                    logger.error(MessageFormat.format(ValidationMessages.getMessage("NOT_FOUND_MEMBER"), elem.getMemberName(), elem.getModuleName().getName()), (ModelObject)elem);
                }
            }
        } else {
            logger.error(ValidationMessages.getMessage("NO_MODULE"), (ModelObject)elem);
        }
    }
}

