/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.validation.rules;

import java.text.MessageFormat;
import org.scribble.common.logging.ScribbleLogger;
import org.scribble.common.module.ModuleContext;
import org.scribble.model.ModelObject;
import org.scribble.model.ProtocolDecl;
import org.scribble.model.local.LBlock;
import org.scribble.model.local.LChoice;
import org.scribble.validation.ValidationMessages;
import org.scribble.validation.rules.ValidationRule;
import org.scribble.validation.rules.ValidationRuleFactory;

public class LChoiceValidationRule
implements ValidationRule {
    public void validate(ModuleContext context, ModelObject mobj, ScribbleLogger logger) {
        LChoice elem = (LChoice)mobj;
        if (elem.getRole() != null) {
            ProtocolDecl pd = (ProtocolDecl)elem.getParent(ProtocolDecl.class);
            if (pd.getRoleDeclaration(elem.getRole().getName()) == null) {
                logger.error(MessageFormat.format(ValidationMessages.getMessage("UNKNOWN_ROLE"), elem.getRole().getName()), (ModelObject)elem.getRole());
            }
        } else {
            logger.error(ValidationMessages.getMessage("UNDEFINED_ROLE"), (ModelObject)elem);
        }
        for (LBlock subelem : elem.getPaths()) {
            ValidationRule rule = ValidationRuleFactory.getValidationRule((ModelObject)subelem);
            if (rule == null) continue;
            rule.validate(context, (ModelObject)subelem, logger);
        }
    }
}

