/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.validation.rules;

import java.text.MessageFormat;
import org.scribble.common.logging.ScribbleLogger;
import org.scribble.common.module.ModuleContext;
import org.scribble.model.Message;
import org.scribble.model.ModelObject;
import org.scribble.model.ParameterDecl;
import org.scribble.model.ProtocolDecl;
import org.scribble.validation.ValidationMessages;
import org.scribble.validation.rules.ValidationRule;
import org.scribble.validation.rules.ValidationRuleFactory;

public class MessageValidationRule
implements ValidationRule {
    public void validate(ModuleContext context, ModelObject mobj, ScribbleLogger logger) {
        ValidationRule rule;
        Message elem = (Message)mobj;
        ProtocolDecl gpd = (ProtocolDecl)elem.getParent(ProtocolDecl.class);
        if (elem.getParameter() != null && gpd != null) {
            boolean f_found = false;
            for (ParameterDecl pd : gpd.getParameterDeclarations()) {
                if (!pd.getName().equals(elem.getParameter()) && (pd.getAlias() == null || !pd.getAlias().equals(elem.getParameter()))) continue;
                f_found = true;
                if (pd.getType() == ParameterDecl.ParameterType.Sig) break;
                logger.error(MessageFormat.format(ValidationMessages.getMessage("PARAMETER_NOT_SIG"), elem.getParameter()), (ModelObject)elem);
                break;
            }
            if (!f_found) {
                logger.error(MessageFormat.format(ValidationMessages.getMessage("UNKNOWN_PARAMETER"), elem.getParameter()), (ModelObject)elem);
            }
        }
        if (elem.getMessageSignature() != null && (rule = ValidationRuleFactory.getValidationRule((ModelObject)elem.getMessageSignature())) != null) {
            rule.validate(context, (ModelObject)elem.getMessageSignature(), logger);
        }
    }
}

