/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.validation.rules;

import java.util.HashMap;
import java.util.Map;
import org.scribble.model.ImportDecl;
import org.scribble.model.Message;
import org.scribble.model.MessageSignature;
import org.scribble.model.ModelObject;
import org.scribble.model.Module;
import org.scribble.model.global.GBlock;
import org.scribble.model.global.GChoice;
import org.scribble.model.global.GDo;
import org.scribble.model.global.GInterruptible;
import org.scribble.model.global.GMessageTransfer;
import org.scribble.model.global.GParallel;
import org.scribble.model.global.GProtocolDefinition;
import org.scribble.model.global.GProtocolInstance;
import org.scribble.model.global.GRecursion;
import org.scribble.model.local.LBlock;
import org.scribble.model.local.LChoice;
import org.scribble.model.local.LDo;
import org.scribble.model.local.LInterruptible;
import org.scribble.model.local.LParallel;
import org.scribble.model.local.LProtocolDefinition;
import org.scribble.model.local.LProtocolInstance;
import org.scribble.model.local.LReceive;
import org.scribble.model.local.LRecursion;
import org.scribble.model.local.LSend;
import org.scribble.validation.rules.GBlockValidationRule;
import org.scribble.validation.rules.GChoiceValidationRule;
import org.scribble.validation.rules.GDoValidationRule;
import org.scribble.validation.rules.GInterruptibleValidationRule;
import org.scribble.validation.rules.GMessageTransferValidationRule;
import org.scribble.validation.rules.GParallelValidationRule;
import org.scribble.validation.rules.GProtocolDefinitionValidationRule;
import org.scribble.validation.rules.GProtocolInstanceValidationRule;
import org.scribble.validation.rules.GRecursionValidationRule;
import org.scribble.validation.rules.ImportDeclValidationRule;
import org.scribble.validation.rules.LBlockValidationRule;
import org.scribble.validation.rules.LChoiceValidationRule;
import org.scribble.validation.rules.LDoValidationRule;
import org.scribble.validation.rules.LInterruptibleValidationRule;
import org.scribble.validation.rules.LParallelValidationRule;
import org.scribble.validation.rules.LProtocolDefinitionValidationRule;
import org.scribble.validation.rules.LProtocolInstanceValidationRule;
import org.scribble.validation.rules.LReceiveValidationRule;
import org.scribble.validation.rules.LRecursionValidationRule;
import org.scribble.validation.rules.LSendValidationRule;
import org.scribble.validation.rules.MessageSignatureValidationRule;
import org.scribble.validation.rules.MessageValidationRule;
import org.scribble.validation.rules.ModuleValidationRule;
import org.scribble.validation.rules.ValidationRule;

public class ValidationRuleFactory {
    private static Map<Class<?>, ValidationRule> _rules = new HashMap();

    public static ValidationRule getValidationRule(ModelObject mobj) {
        return _rules.get(mobj.getClass());
    }

    static {
        _rules.put(GBlock.class, new GBlockValidationRule());
        _rules.put(GChoice.class, new GChoiceValidationRule());
        _rules.put(GDo.class, new GDoValidationRule());
        _rules.put(GInterruptible.class, new GInterruptibleValidationRule());
        _rules.put(GMessageTransfer.class, new GMessageTransferValidationRule());
        _rules.put(GParallel.class, new GParallelValidationRule());
        _rules.put(GProtocolDefinition.class, new GProtocolDefinitionValidationRule());
        _rules.put(GProtocolInstance.class, new GProtocolInstanceValidationRule());
        _rules.put(GRecursion.class, new GRecursionValidationRule());
        _rules.put(ImportDecl.class, new ImportDeclValidationRule());
        _rules.put(LBlock.class, new LBlockValidationRule());
        _rules.put(LChoice.class, new LChoiceValidationRule());
        _rules.put(LDo.class, new LDoValidationRule());
        _rules.put(LInterruptible.class, new LInterruptibleValidationRule());
        _rules.put(LParallel.class, new LParallelValidationRule());
        _rules.put(LProtocolDefinition.class, new LProtocolDefinitionValidationRule());
        _rules.put(LProtocolInstance.class, new LProtocolInstanceValidationRule());
        _rules.put(LReceive.class, new LReceiveValidationRule());
        _rules.put(LRecursion.class, new LRecursionValidationRule());
        _rules.put(LSend.class, new LSendValidationRule());
        _rules.put(Message.class, new MessageValidationRule());
        _rules.put(MessageSignature.class, new MessageSignatureValidationRule());
        _rules.put(Module.class, new ModuleValidationRule());
    }
}

