/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.validation.rules;

import java.text.MessageFormat;
import org.scribble.context.ModuleContext;
import org.scribble.logging.IssueLogger;
import org.scribble.model.Argument;
import org.scribble.model.ModelObject;
import org.scribble.model.Module;
import org.scribble.model.PayloadTypeDecl;
import org.scribble.model.RoleInstantiation;
import org.scribble.model.local.LProtocolDefinition;
import org.scribble.model.local.LProtocolInstance;
import org.scribble.validation.rules.ValidationMessages;
import org.scribble.validation.rules.ValidationRule;

public class LProtocolInstanceValidationRule
implements ValidationRule {
    public void validate(ModuleContext context, ModelObject mobj, IssueLogger logger) {
        LProtocolInstance elem = (LProtocolInstance)mobj;
        if (elem.getLocalRole() != null && elem.getRoleDeclaration(elem.getLocalRole().getName()) == null) {
            logger.error(MessageFormat.format(ValidationMessages.getMessage("LOCAL_ROLE_NOT_DECLARED"), elem.getLocalRole().getName()), (ModelObject)elem);
        }
        if (elem.getMemberName() != null) {
            ModelObject refd = context.getMember(elem.getMemberName());
            if (refd == null) {
                logger.error(MessageFormat.format(ValidationMessages.getMessage("UNKNOWN_MEMBER_NAME"), elem.getMemberName()), (ModelObject)elem);
            } else if (!(refd instanceof LProtocolDefinition)) {
                logger.error(MessageFormat.format(ValidationMessages.getMessage("MEMBER_NOT_PROTOCOL_DEFINITION"), elem.getMemberName()), (ModelObject)elem);
            } else {
                LProtocolDefinition pd = (LProtocolDefinition)refd;
                if (pd.getParameterDeclarations().size() != elem.getArguments().size()) {
                    logger.error(MessageFormat.format(ValidationMessages.getMessage("ARG_NUM_MISMATCH"), elem.getArguments().size(), pd.getParameterDeclarations().size()), (ModelObject)elem);
                }
                for (Argument arg : elem.getArguments()) {
                    if (arg.getName() != null) {
                        Module m = elem.getModule();
                        PayloadTypeDecl ptd = null;
                        if (m != null) {
                            ptd = m.getTypeDeclaration(arg.getName());
                        }
                        if (ptd == null && elem.getParameterDeclaration(arg.getName()) == null) {
                            logger.error(MessageFormat.format(ValidationMessages.getMessage("ARG_NOT_DECLARED"), arg.getName()), (ModelObject)elem);
                        }
                    }
                    if (arg.getAlias() == null || pd.getParameterDeclaration(arg.getAlias()) != null) continue;
                    logger.error(MessageFormat.format(ValidationMessages.getMessage("ARG_ALIAS_NOT_DECLARED"), arg.getAlias()), (ModelObject)elem);
                }
                if (pd.getRoleDeclarations().size() != elem.getRoleInstantiations().size()) {
                    logger.error(MessageFormat.format(ValidationMessages.getMessage("ROLE_NUM_MISMATCH"), elem.getRoleInstantiations().size(), pd.getRoleDeclarations().size()), (ModelObject)elem);
                }
                for (RoleInstantiation ri : elem.getRoleInstantiations()) {
                    if (ri.getName() != null && elem.getRoleDeclaration(ri.getName()) == null) {
                        logger.error(MessageFormat.format(ValidationMessages.getMessage("ROLE_NOT_DECLARED"), ri.getName()), (ModelObject)elem);
                    }
                    if (ri.getAlias() == null || pd.getRoleDeclaration(ri.getAlias()) != null) continue;
                    logger.error(MessageFormat.format(ValidationMessages.getMessage("ROLE_ALIAS_NOT_DECLARED"), ri.getAlias()), (ModelObject)elem);
                }
            }
        }
    }
}

