/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.validation.rules;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.scribble.context.ModuleContext;
import org.scribble.logging.IssueLogger;
import org.scribble.model.ImportDecl;
import org.scribble.model.ModelObject;
import org.scribble.model.Module;
import org.scribble.model.PayloadTypeDecl;
import org.scribble.model.ProtocolDecl;
import org.scribble.model.Role;
import org.scribble.model.local.LProtocolDecl;
import org.scribble.validation.rules.ValidationMessages;
import org.scribble.validation.rules.ValidationRule;
import org.scribble.validation.rules.ValidationRuleFactory;

public class ModuleValidationRule
implements ValidationRule {
    public void validate(ModuleContext context, ModelObject mobj, IssueLogger logger) {
        int pos;
        ValidationRule rule;
        Module elem = (Module)mobj;
        if (elem.getName() == null) {
            logger.error(ValidationMessages.getMessage("NO_FULLY_QUALIFIED_NAME"), mobj);
        }
        for (ImportDecl imp : elem.getImports()) {
            rule = ValidationRuleFactory.getValidationRule((ModelObject)imp);
            if (rule == null) continue;
            rule.validate(context, (ModelObject)imp, logger);
        }
        for (PayloadTypeDecl ptd : elem.getPayloadTypeDeclarations()) {
            rule = ValidationRuleFactory.getValidationRule((ModelObject)ptd);
            if (rule == null) continue;
            rule.validate(context, (ModelObject)ptd, logger);
        }
        boolean f_global = true;
        String localRole = null;
        if (context.getResource() != null && (pos = context.getResource().getPath().indexOf(64)) != -1) {
            f_global = false;
            localRole = context.getResource().getPath().substring(pos + 1, context.getResource().getPath().length() - 4);
        }
        for (int i = 0; i < elem.getProtocols().size(); ++i) {
            ValidationRule rule2;
            ProtocolDecl protocol = (ProtocolDecl)elem.getProtocols().get(i);
            if (context.getResource() != null) {
                if (protocol instanceof LProtocolDecl) {
                    Role role = ((LProtocolDecl)protocol).getLocalRole();
                    if (f_global) {
                        logger.error(MessageFormat.format(ValidationMessages.getMessage("LOCAL_DEFINED_IN_GLOBAL_MODULE"), role.getName()), (ModelObject)protocol);
                    } else if (!role.getName().equals(localRole)) {
                        logger.error(MessageFormat.format(ValidationMessages.getMessage("LOCAL_MODULE_ROLE_MISMATCH"), role.getName(), localRole), (ModelObject)protocol);
                    }
                } else if (!f_global) {
                    logger.error(MessageFormat.format(ValidationMessages.getMessage("GLOBAL_DEFINED_IN_LOCAL_MODULE"), localRole), (ModelObject)protocol);
                }
            }
            if ((rule2 = ValidationRuleFactory.getValidationRule((ModelObject)protocol)) == null) continue;
            rule2.validate(context, (ModelObject)protocol, logger);
        }
        if (context.getResource() != null && context.getResource().getPath() != null) {
            String filepath = elem.getName().replace('.', File.separatorChar);
            if (localRole != null) {
                filepath = filepath + "@" + localRole;
            }
            filepath = filepath + ".scr";
            if (!context.getResource().getPath().equals(filepath)) {
                logger.error(MessageFormat.format(ValidationMessages.getMessage("INCORRECT_FILEPATH"), elem.getName(), filepath), mobj);
            }
        }
        ArrayList<String> moduleNames = new ArrayList<String>();
        if (elem.getName() != null) {
            moduleNames.add(elem.getLocalName());
        }
        for (ImportDecl imp : elem.getImports()) {
            if (imp.getMemberName() != null) continue;
            String declName = imp.getDeclarationName();
            if (moduleNames.contains(declName)) {
                logger.error(MessageFormat.format(ValidationMessages.getMessage("MODULE_NAME_NOT_DISTINCT"), declName), mobj);
                continue;
            }
            moduleNames.add(declName);
        }
        ArrayList<String> memberNames = new ArrayList<String>();
        for (ImportDecl imp : elem.getImports()) {
            if (imp.getMemberName() == null) continue;
            String declName = imp.getDeclarationName();
            if (memberNames.contains(declName)) {
                logger.error(MessageFormat.format(ValidationMessages.getMessage("MEMBER_NAME_NOT_DISTINCT"), declName), (ModelObject)imp);
                continue;
            }
            memberNames.add(declName);
        }
        for (PayloadTypeDecl plt : elem.getPayloadTypeDeclarations()) {
            if (memberNames.contains(plt.getAlias())) {
                logger.error(MessageFormat.format(ValidationMessages.getMessage("MEMBER_NAME_NOT_DISTINCT"), plt.getAlias()), (ModelObject)plt);
                continue;
            }
            memberNames.add(plt.getAlias());
        }
        for (ProtocolDecl pd : elem.getProtocols()) {
            if (memberNames.contains(pd.getName())) {
                logger.error(MessageFormat.format(ValidationMessages.getMessage("MEMBER_NAME_NOT_DISTINCT"), pd.getName()), (ModelObject)pd);
                continue;
            }
            memberNames.add(pd.getName());
        }
    }
}

