/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.validation.rules;

import java.text.MessageFormat;
import org.scribble.context.ModuleContext;
import org.scribble.logging.IssueLogger;
import org.scribble.model.ModelObject;
import org.scribble.model.global.GContinue;
import org.scribble.model.global.GInterruptible;
import org.scribble.model.global.GParallel;
import org.scribble.model.global.GProtocolDefinition;
import org.scribble.model.global.GRecursion;
import org.scribble.validation.rules.ValidationMessages;
import org.scribble.validation.rules.ValidationRule;

public class GContinueValidationRule
implements ValidationRule {
    @Override
    public void validate(ModuleContext context, ModelObject mobj, IssueLogger logger) {
        GContinue elem = (GContinue)mobj;
        if (elem.getLabel() == null) {
            logger.error(ValidationMessages.getMessage("LABEL_NOT_DEFINED"), (ModelObject)elem);
            return;
        }
        GContinue act = elem;
        do {
            if ((act = act.getParent()) instanceof GProtocolDefinition || act == null) {
                logger.error(MessageFormat.format(ValidationMessages.getMessage("LABEL_NOT_BOUND"), elem.getLabel()), (ModelObject)elem);
            } else if (act instanceof GParallel) {
                logger.error(ValidationMessages.getMessage("LABEL_CONTAINED_IN_PARALLEL"), (ModelObject)elem);
            } else {
                if (!(act instanceof GInterruptible)) continue;
                logger.error(ValidationMessages.getMessage("LABEL_CONTAINED_IN_INTERRUPTIBLE"), (ModelObject)elem);
            }
            break;
        } while (!(act instanceof GRecursion) || !elem.getLabel().equals(((GRecursion)act).getLabel()));
    }
}

