/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.validation.rules;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.scribble.context.ModuleContext;
import org.scribble.logging.IssueLogger;
import org.scribble.model.ImportDecl;
import org.scribble.model.ModelObject;
import org.scribble.model.ParameterDecl;
import org.scribble.model.PayloadElement;
import org.scribble.model.PayloadTypeDecl;
import org.scribble.model.RoleDecl;
import org.scribble.model.global.DefaultGVisitor;
import org.scribble.model.global.GDo;
import org.scribble.model.global.GInterruptible;
import org.scribble.model.global.GMessageTransfer;
import org.scribble.model.global.GProtocolDefinition;
import org.scribble.model.global.GVisitor;
import org.scribble.validation.rules.ValidationMessages;
import org.scribble.validation.rules.ValidationRule;
import org.scribble.validation.rules.ValidationRuleFactory;

public class GProtocolDefinitionValidationRule
implements ValidationRule {
    @Override
    public void validate(ModuleContext context, final ModelObject mobj, final IssueLogger logger) {
        ValidationRule rule;
        GProtocolDefinition elem = (GProtocolDefinition)mobj;
        ArrayList<String> roleNames = new ArrayList<String>();
        for (RoleDecl rd : elem.getRoleDeclarations()) {
            String roleName = rd.getDeclarationName();
            if (roleNames.contains(roleName)) {
                logger.error(MessageFormat.format(ValidationMessages.getMessage("ROLE_NAME_NOT_DISTINCT"), roleName), mobj);
                continue;
            }
            roleNames.add(roleName);
        }
        ArrayList<String> paramNames = new ArrayList<String>();
        for (PayloadTypeDecl ptd : elem.getModule().getPayloadTypeDeclarations()) {
            paramNames.add(ptd.getAlias());
        }
        for (ImportDecl imp : elem.getModule().getImports()) {
            paramNames.add(imp.getDeclarationName());
        }
        for (ParameterDecl pd : elem.getParameterDeclarations()) {
            String paramName = pd.getDeclarationName();
            if (paramNames.contains(paramName)) {
                logger.error(MessageFormat.format(ValidationMessages.getMessage("PARAMETER_NAME_NOT_DISTINCT"), paramName), mobj);
                continue;
            }
            paramNames.add(paramName);
        }
        final ArrayList scopeNames = new ArrayList();
        elem.getBlock().visit((GVisitor)new DefaultGVisitor(){

            public boolean start(GInterruptible elem) {
                this.verifyScope(elem.getScope());
                return true;
            }

            public void accept(GDo elem) {
                this.verifyScope(elem.getScope());
            }

            protected void verifyScope(String scope) {
                if (scope != null) {
                    if (scopeNames.contains(scope)) {
                        logger.error(MessageFormat.format(ValidationMessages.getMessage("SCOPE_NOT_DISTINCT"), scope), mobj);
                    } else {
                        scopeNames.add(scope);
                    }
                }
            }
        });
        final ArrayList annotationNames = new ArrayList();
        elem.getBlock().visit((GVisitor)new DefaultGVisitor(){

            public void accept(GMessageTransfer elem) {
                if (elem.getMessage().getMessageSignature() != null) {
                    for (PayloadElement pe : elem.getMessage().getMessageSignature().getPayloadElements()) {
                        if (pe.getAnnotation() == null) continue;
                        if (annotationNames.contains(pe.getAnnotation())) {
                            logger.error(MessageFormat.format(ValidationMessages.getMessage("ANNOTATION_NOT_DISTINCT"), pe.getAnnotation()), mobj);
                            continue;
                        }
                        annotationNames.add(pe.getAnnotation());
                    }
                }
            }
        });
        if (elem.getBlock() != null && (rule = ValidationRuleFactory.getValidationRule((ModelObject)elem.getBlock())) != null) {
            rule.validate(context, (ModelObject)elem.getBlock(), logger);
        }
    }
}

