/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.validation.rules;

import java.text.MessageFormat;
import java.util.HashSet;
import org.scribble.context.ModuleContext;
import org.scribble.logging.IssueLogger;
import org.scribble.model.ModelObject;
import org.scribble.model.Visitor;
import org.scribble.model.global.DefaultGVisitor;
import org.scribble.model.global.GProtocolDefinition;
import org.scribble.model.global.GRecursion;
import org.scribble.validation.rules.ValidationMessages;
import org.scribble.validation.rules.ValidationRule;
import org.scribble.validation.rules.ValidationRuleFactory;

public class GRecursionValidationRule
implements ValidationRule {
    @Override
    public void validate(ModuleContext context, ModelObject mobj, final IssueLogger logger) {
        ValidationRule rule;
        final GRecursion elem = (GRecursion)mobj;
        GProtocolDefinition gpd = (GProtocolDefinition)elem.getParent(GProtocolDefinition.class);
        if (gpd != null && elem.getLabel() != null) {
            final HashSet<String> labels = new HashSet<String>();
            labels.add(elem.getLabel());
            gpd.visit((Visitor)new DefaultGVisitor(){

                public boolean start(GRecursion rec) {
                    if (elem != rec && rec.getLabel() != null) {
                        if (labels.contains(rec.getLabel())) {
                            logger.error(MessageFormat.format(ValidationMessages.getMessage("LABEL_NOT_UNIQUE"), rec.getLabel()), (ModelObject)elem);
                        }
                        labels.add(rec.getLabel());
                    }
                    return true;
                }
            });
        }
        if (elem.getBlock() != null && (rule = ValidationRuleFactory.getValidationRule((ModelObject)elem.getBlock())) != null) {
            rule.validate(context, (ModelObject)elem.getBlock(), logger);
        }
    }
}

