/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.validation.rules;

import java.text.MessageFormat;
import org.scribble.context.ModuleContext;
import org.scribble.logging.IssueLogger;
import org.scribble.model.MessageSignature;
import org.scribble.model.ModelObject;
import org.scribble.model.ParameterDecl;
import org.scribble.model.PayloadElement;
import org.scribble.model.PayloadTypeDecl;
import org.scribble.model.ProtocolDecl;
import org.scribble.validation.rules.ValidationMessages;
import org.scribble.validation.rules.ValidationRule;

public class MessageSignatureValidationRule
implements ValidationRule {
    @Override
    public void validate(ModuleContext context, ModelObject mobj, IssueLogger logger) {
        MessageSignature elem = (MessageSignature)mobj;
        ProtocolDecl gpd = (ProtocolDecl)elem.getParent(ProtocolDecl.class);
        for (PayloadElement pt : elem.getPayloadElements()) {
            ModelObject alias;
            if (pt.getName() == null) continue;
            boolean f_found = false;
            if (gpd != null) {
                for (ParameterDecl pd : gpd.getParameterDeclarations()) {
                    if (!pd.getName().equals(pt.getName()) && (pd.getAlias() == null || !pd.getAlias().equals(pt.getName()))) continue;
                    f_found = true;
                    break;
                }
            }
            if (!f_found) {
                PayloadTypeDecl ptype = elem.getModule().getTypeDeclaration(pt.getName());
                boolean bl = f_found = ptype != null;
            }
            if (!f_found && context != null && (alias = context.getMember(pt.getName())) instanceof PayloadTypeDecl) {
                f_found = true;
            }
            if (f_found) continue;
            logger.error(MessageFormat.format(ValidationMessages.getMessage("UNKNOWN_PAYLOAD_ELEMENT"), pt.getName()), (ModelObject)elem);
        }
    }
}

