/*
 * Decompiled with CFR 0.152.
 */
package org.phprpc;

import java.io.IOException;
import java.net.Socket;
import java.util.LinkedList;
import javax.net.SocketFactory;

final class SocketPool {
    private LinkedList sockets = new LinkedList();
    private SocketFactory socketFactory;
    private String host;
    private int port;
    private int timeout;

    SocketPool(SocketFactory socketFactory, String host, int port, int timeout) {
        this.socketFactory = socketFactory;
        this.host = host;
        this.port = port;
        this.timeout = timeout;
    }

    private final Socket newSocket() throws IOException {
        Socket socket = this.socketFactory.createSocket(this.host, this.port);
        socket.setSoTimeout(this.timeout);
        socket.setTcpNoDelay(true);
        socket.setKeepAlive(true);
        return socket;
    }

    public final synchronized Socket getConnect() throws IOException {
        Socket socket = null;
        if (!this.sockets.isEmpty()) {
            socket = (Socket)this.sockets.removeFirst();
        }
        if (socket == null || socket.isClosed() || socket.isInputShutdown() || socket.isOutputShutdown() || !socket.isConnected()) {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            socket = this.newSocket();
        }
        return socket;
    }

    public final synchronized void freeConnect(Socket socket, boolean keepAlive) {
        if (keepAlive) {
            this.sockets.addLast(socket);
        } else if (socket != null) {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public final synchronized void clearConnect() {
        while (!this.sockets.isEmpty()) {
            Socket socket = (Socket)this.sockets.removeLast();
            if (socket == null) continue;
            try {
                socket.close();
            }
            catch (IOException iOException) {}
        }
        this.sockets.clear();
    }

    public final void finalize() throws Throwable {
        super.finalize();
        this.clearConnect();
    }
}

