/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt;

import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.Context;
import org.seasar.doma.internal.util.AssertionUtil;

public class Names {
    private final Context ctx;

    Names(Context ctx) {
        AssertionUtil.assertNotNull(ctx);
        this.ctx = ctx;
    }

    public Name createExternalDomainName(TypeMirror externalDomainType) {
        AssertionUtil.assertNotNull(externalDomainType);
        ArrayType arrayType = this.ctx.getMoreTypes().toArrayType(externalDomainType);
        if (arrayType != null) {
            TypeMirror componentType = arrayType.getComponentType();
            TypeElement componentElement = this.ctx.getMoreTypes().toTypeElement(componentType);
            if (componentElement == null) {
                throw new AptIllegalStateException(componentType.toString());
            }
            Name binaryName = this.ctx.getMoreElements().getBinaryName(componentElement);
            return this.ctx.getMoreElements().getName(binaryName + "__ARRAY__");
        }
        TypeElement domainElement = this.ctx.getMoreTypes().toTypeElement(externalDomainType);
        if (domainElement == null) {
            throw new AptIllegalStateException(externalDomainType.toString());
        }
        return this.ctx.getMoreElements().getBinaryName(domainElement);
    }
}

