/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.annot;

import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.annot.AbstractAnnot;
import org.seasar.doma.internal.apt.util.AnnotationValueUtil;
import org.seasar.doma.internal.util.AssertionUtil;

public class AnnotationAnnot
extends AbstractAnnot {
    private static final String TARGET = "target";
    private static final String TYPE = "type";
    private static final String ELEMENTS = "elements";
    private final AnnotationValue target;
    private final AnnotationValue type;
    private final AnnotationValue elements;

    AnnotationAnnot(AnnotationMirror annotationMirror, Map<String, AnnotationValue> values) {
        super(annotationMirror);
        this.target = AssertionUtil.assertNonNullValue(values, TARGET);
        this.type = AssertionUtil.assertNonNullValue(values, TYPE);
        this.elements = AssertionUtil.assertNonNullValue(values, ELEMENTS);
    }

    public AnnotationValue getTarget() {
        return this.target;
    }

    public AnnotationValue getType() {
        return this.type;
    }

    public AnnotationValue getElements() {
        return this.elements;
    }

    public VariableElement getTargetValue() {
        VariableElement value = AnnotationValueUtil.toEnumConstant(this.target);
        if (value == null) {
            throw new AptIllegalStateException(TARGET);
        }
        return value;
    }

    public TypeMirror getTypeValue() {
        TypeMirror value = AnnotationValueUtil.toType(this.type);
        if (value == null) {
            throw new AptIllegalStateException(TYPE);
        }
        return value;
    }

    public String getElementsValue() {
        String value = AnnotationValueUtil.toString(this.elements);
        if (value == null) {
            throw new AptIllegalStateException(ELEMENTS);
        }
        return value;
    }
}

