/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.annot;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.BiFunction;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.seasar.doma.AnnotateWith;
import org.seasar.doma.ArrayFactory;
import org.seasar.doma.BatchDelete;
import org.seasar.doma.BatchInsert;
import org.seasar.doma.BatchUpdate;
import org.seasar.doma.BlobFactory;
import org.seasar.doma.ClobFactory;
import org.seasar.doma.Column;
import org.seasar.doma.Dao;
import org.seasar.doma.Delete;
import org.seasar.doma.Domain;
import org.seasar.doma.DomainConverters;
import org.seasar.doma.Embeddable;
import org.seasar.doma.Entity;
import org.seasar.doma.Function;
import org.seasar.doma.Insert;
import org.seasar.doma.NClobFactory;
import org.seasar.doma.Procedure;
import org.seasar.doma.ResultSet;
import org.seasar.doma.SQLXMLFactory;
import org.seasar.doma.Script;
import org.seasar.doma.Select;
import org.seasar.doma.SequenceGenerator;
import org.seasar.doma.SingletonConfig;
import org.seasar.doma.SqlProcessor;
import org.seasar.doma.Table;
import org.seasar.doma.TableGenerator;
import org.seasar.doma.Update;
import org.seasar.doma.experimental.DataType;
import org.seasar.doma.experimental.Sql;
import org.seasar.doma.internal.apt.Context;
import org.seasar.doma.internal.apt.annot.AllArgsConstructorAnnot;
import org.seasar.doma.internal.apt.annot.AnnotateWithAnnot;
import org.seasar.doma.internal.apt.annot.AnnotationAnnot;
import org.seasar.doma.internal.apt.annot.ArrayFactoryAnnot;
import org.seasar.doma.internal.apt.annot.BatchDeleteAnnot;
import org.seasar.doma.internal.apt.annot.BatchInsertAnnot;
import org.seasar.doma.internal.apt.annot.BatchUpdateAnnot;
import org.seasar.doma.internal.apt.annot.BlobFactoryAnnot;
import org.seasar.doma.internal.apt.annot.ClobFactoryAnnot;
import org.seasar.doma.internal.apt.annot.ColumnAnnot;
import org.seasar.doma.internal.apt.annot.DaoAnnot;
import org.seasar.doma.internal.apt.annot.DataTypeAnnot;
import org.seasar.doma.internal.apt.annot.DeleteAnnot;
import org.seasar.doma.internal.apt.annot.DomainAnnot;
import org.seasar.doma.internal.apt.annot.DomainConvertersAnnot;
import org.seasar.doma.internal.apt.annot.EmbeddableAnnot;
import org.seasar.doma.internal.apt.annot.EntityAnnot;
import org.seasar.doma.internal.apt.annot.FunctionAnnot;
import org.seasar.doma.internal.apt.annot.InsertAnnot;
import org.seasar.doma.internal.apt.annot.NClobFactoryAnnot;
import org.seasar.doma.internal.apt.annot.ProcedureAnnot;
import org.seasar.doma.internal.apt.annot.ResultSetAnnot;
import org.seasar.doma.internal.apt.annot.SQLXMLFactoryAnnot;
import org.seasar.doma.internal.apt.annot.ScriptAnnot;
import org.seasar.doma.internal.apt.annot.SelectAnnot;
import org.seasar.doma.internal.apt.annot.SequenceGeneratorAnnot;
import org.seasar.doma.internal.apt.annot.SingletonConfigAnnot;
import org.seasar.doma.internal.apt.annot.SqlAnnot;
import org.seasar.doma.internal.apt.annot.SqlProcessorAnnot;
import org.seasar.doma.internal.apt.annot.TableAnnot;
import org.seasar.doma.internal.apt.annot.TableGeneratorAnnot;
import org.seasar.doma.internal.apt.annot.UpdateAnnot;
import org.seasar.doma.internal.apt.annot.ValueAnnot;
import org.seasar.doma.internal.apt.util.AnnotationValueUtil;
import org.seasar.doma.internal.util.AssertionUtil;

public class Annotations {
    private final Context ctx;

    public Annotations(Context ctx) {
        this.ctx = ctx;
    }

    public AllArgsConstructorAnnot newAllArgsConstructorAnnot(TypeElement typeElement) {
        AssertionUtil.assertNotNull(typeElement);
        return this.newInstance((Element)typeElement, this.ctx.getOptions().getLombokAllArgsConstructor(), AllArgsConstructorAnnot::new);
    }

    public AnnotateWithAnnot newAnnotateWithAnnot(TypeElement typeElement) {
        AssertionUtil.assertNotNull(typeElement);
        AnnotationMirror annotateWith = this.ctx.getMoreElements().getAnnotationMirror((Element)typeElement, AnnotateWith.class);
        if (annotateWith == null) {
            for (AnnotationMirror annotationMirror : typeElement.getAnnotationMirrors()) {
                TypeElement ownerElement = this.ctx.getMoreElements().toTypeElement(annotationMirror.getAnnotationType().asElement());
                if (ownerElement == null || (annotateWith = this.ctx.getMoreElements().getAnnotationMirror((Element)ownerElement, AnnotateWith.class)) == null) continue;
                break;
            }
            if (annotateWith == null) {
                return null;
            }
        }
        Map<String, AnnotationValue> values = this.ctx.getMoreElements().getValuesWithDefaults(annotateWith);
        AnnotationValue annotationValue = values.get("annotations");
        ArrayList<AnnotationAnnot> annotationsValue = new ArrayList<AnnotationAnnot>();
        for (AnnotationMirror annotationMirror : AnnotationValueUtil.toAnnotationList(annotationValue)) {
            annotationsValue.add(this.newAnnotationAnnot(annotationMirror));
        }
        return new AnnotateWithAnnot(annotateWith, annotationValue, annotationsValue);
    }

    private AnnotationAnnot newAnnotationAnnot(AnnotationMirror annotationMirror) {
        AssertionUtil.assertNotNull(annotationMirror);
        return this.newInstance(annotationMirror, AnnotationAnnot::new);
    }

    public ArrayFactoryAnnot newArrayFactoryAnnot(ExecutableElement method) {
        AssertionUtil.assertNotNull(method);
        return this.newInstance((Element)method, ArrayFactory.class, ArrayFactoryAnnot::new);
    }

    public BatchDeleteAnnot newBatchDeleteAnnot(ExecutableElement method) {
        AssertionUtil.assertNotNull(method);
        return this.newInstance((Element)method, BatchDelete.class, BatchDeleteAnnot::new);
    }

    public BatchInsertAnnot newBatchInsertAnnot(ExecutableElement method) {
        AssertionUtil.assertNotNull(method);
        return this.newInstance((Element)method, BatchInsert.class, BatchInsertAnnot::new);
    }

    public BatchUpdateAnnot newBatchUpdateAnnot(ExecutableElement method) {
        AssertionUtil.assertNotNull(method);
        return this.newInstance((Element)method, BatchUpdate.class, BatchUpdateAnnot::new);
    }

    public BlobFactoryAnnot newBlobFactoryAnnot(ExecutableElement method) {
        AssertionUtil.assertNotNull(method);
        return this.newInstance((Element)method, BlobFactory.class, BlobFactoryAnnot::new);
    }

    public ClobFactoryAnnot newClobFactoryAnnot(ExecutableElement method) {
        AssertionUtil.assertNotNull(method);
        return this.newInstance((Element)method, ClobFactory.class, ClobFactoryAnnot::new);
    }

    public ColumnAnnot newColumnAnnot(VariableElement field) {
        AssertionUtil.assertNotNull(field);
        return this.newInstance((Element)field, Column.class, ColumnAnnot::new);
    }

    public DaoAnnot newDaoAnnot(TypeElement typeElement) {
        AssertionUtil.assertNotNull(typeElement);
        return this.newInstance((Element)typeElement, Dao.class, DaoAnnot::new);
    }

    public DataTypeAnnot newDataTypeAnnot(TypeElement typeElement) {
        AssertionUtil.assertNotNull(typeElement);
        return this.newInstance((Element)typeElement, DataType.class, DataTypeAnnot::new);
    }

    public DomainAnnot newDomainAnnot(TypeElement typeElement) {
        AssertionUtil.assertNotNull(typeElement);
        return this.newInstance((Element)typeElement, Domain.class, DomainAnnot::new);
    }

    public DomainConvertersAnnot newDomainConvertersAnnot(TypeElement typeElement) {
        AssertionUtil.assertNotNull(typeElement);
        return this.newInstance((Element)typeElement, DomainConverters.class, DomainConvertersAnnot::new);
    }

    public DeleteAnnot newDeleteAnnot(ExecutableElement method) {
        AssertionUtil.assertNotNull(method);
        return this.newInstance((Element)method, Delete.class, DeleteAnnot::new);
    }

    public EmbeddableAnnot newEmbeddableAnnot(TypeElement typeElement) {
        AssertionUtil.assertNotNull(typeElement);
        return this.newInstance((Element)typeElement, Embeddable.class, EmbeddableAnnot::new);
    }

    public EntityAnnot newEntityAnnot(TypeElement typeElement) {
        AssertionUtil.assertNotNull(typeElement);
        return this.newInstance((Element)typeElement, Entity.class, EntityAnnot::new);
    }

    public FunctionAnnot newFunctionAnnot(ExecutableElement method) {
        AssertionUtil.assertNotNull(method);
        return this.newInstance((Element)method, Function.class, (AnnotationMirror annotationMirror, Map<String, AnnotationValue> values) -> new FunctionAnnot((AnnotationMirror)annotationMirror, (Map<String, AnnotationValue>)values, method.getSimpleName().toString()));
    }

    public InsertAnnot newInsertAnnot(ExecutableElement method) {
        AssertionUtil.assertNotNull(method);
        return this.newInstance((Element)method, Insert.class, InsertAnnot::new);
    }

    public NClobFactoryAnnot newNClobFactoryAnnot(ExecutableElement method) {
        AssertionUtil.assertNotNull(method);
        return this.newInstance((Element)method, NClobFactory.class, NClobFactoryAnnot::new);
    }

    public ProcedureAnnot newProcedureAnnot(ExecutableElement method) {
        AssertionUtil.assertNotNull(method);
        return this.newInstance((Element)method, Procedure.class, (AnnotationMirror annotationMirror, Map<String, AnnotationValue> values) -> new ProcedureAnnot((AnnotationMirror)annotationMirror, (Map<String, AnnotationValue>)values, method.getSimpleName().toString()));
    }

    public ResultSetAnnot newResultSetAnnot(VariableElement param) {
        AssertionUtil.assertNotNull(param);
        return this.newInstance((Element)param, ResultSet.class, ResultSetAnnot::new);
    }

    public ScriptAnnot newScriptAnnot(ExecutableElement method) {
        AssertionUtil.assertNotNull(method);
        return this.newInstance((Element)method, Script.class, ScriptAnnot::new);
    }

    public SelectAnnot newSelectAnnot(ExecutableElement method) {
        AssertionUtil.assertNotNull(method);
        return this.newInstance((Element)method, Select.class, SelectAnnot::new);
    }

    public SequenceGeneratorAnnot newSequenceGeneratorAnnot(VariableElement field) {
        AssertionUtil.assertNotNull(field);
        return this.newInstance((Element)field, SequenceGenerator.class, SequenceGeneratorAnnot::new);
    }

    public SingletonConfigAnnot newSingletonConfigAnnot(TypeElement typeElement) {
        AssertionUtil.assertNotNull(typeElement);
        return this.newInstance((Element)typeElement, SingletonConfig.class, SingletonConfigAnnot::new);
    }

    public SqlAnnot newSqlAnnot(ExecutableElement method) {
        AssertionUtil.assertNotNull(method);
        return this.newInstance((Element)method, Sql.class, SqlAnnot::new);
    }

    public SqlProcessorAnnot newSqlProcessorAnnot(ExecutableElement method) {
        AssertionUtil.assertNotNull(method);
        return this.newInstance((Element)method, SqlProcessor.class, SqlProcessorAnnot::new);
    }

    public SQLXMLFactoryAnnot newSQLXMLFactoryAnnot(ExecutableElement method) {
        AssertionUtil.assertNotNull(method);
        return this.newInstance((Element)method, SQLXMLFactory.class, SQLXMLFactoryAnnot::new);
    }

    public TableGeneratorAnnot newTableGeneratorAnnot(VariableElement field) {
        AssertionUtil.assertNotNull(field);
        return this.newInstance((Element)field, TableGenerator.class, TableGeneratorAnnot::new);
    }

    public TableAnnot newTableAnnot(TypeElement typeElement) {
        AssertionUtil.assertNotNull(typeElement);
        return this.newInstance((Element)typeElement, Table.class, TableAnnot::new);
    }

    public UpdateAnnot newUpdateAnnot(ExecutableElement method) {
        AssertionUtil.assertNotNull(method);
        return this.newInstance((Element)method, Update.class, UpdateAnnot::new);
    }

    public ValueAnnot newValueAnnot(TypeElement typeElement) {
        AssertionUtil.assertNotNull(typeElement);
        return this.newInstance((Element)typeElement, this.ctx.getOptions().getLombokValue(), ValueAnnot::new);
    }

    private <ANNOT> ANNOT newInstance(Element element, Class<? extends Annotation> annotationClass, java.util.function.Function<AnnotationMirror, ANNOT> function) {
        return (ANNOT)this.newInstance(element, annotationClass, (AnnotationMirror annotationMirror, Map<String, AnnotationValue> __) -> function.apply((AnnotationMirror)annotationMirror));
    }

    private <ANNOT> ANNOT newInstance(Element element, Class<? extends Annotation> annotationClass, BiFunction<AnnotationMirror, Map<String, AnnotationValue>, ANNOT> biFunction) {
        AnnotationMirror annotationMirror = this.ctx.getMoreElements().getAnnotationMirror(element, annotationClass);
        return this.newInstance(annotationMirror, biFunction);
    }

    private <ANNOT> ANNOT newInstance(Element element, String annotationClassName, BiFunction<AnnotationMirror, Map<String, AnnotationValue>, ANNOT> biFunction) {
        AnnotationMirror annotationMirror = this.ctx.getMoreElements().getAnnotationMirror(element, annotationClassName);
        return this.newInstance(annotationMirror, biFunction);
    }

    private <ANNOT> ANNOT newInstance(AnnotationMirror annotationMirror, BiFunction<AnnotationMirror, Map<String, AnnotationValue>, ANNOT> biFunction) {
        if (annotationMirror == null) {
            return null;
        }
        Map<String, AnnotationValue> values = this.ctx.getMoreElements().getValuesWithDefaults(annotationMirror);
        return biFunction.apply(annotationMirror, values);
    }
}

