/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.annot;

import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.annot.AbstractAnnot;
import org.seasar.doma.internal.apt.util.AnnotationValueUtil;
import org.seasar.doma.internal.util.AssertionUtil;

public class DomainAnnot
extends AbstractAnnot {
    private static final String VALUE_TYPE = "valueType";
    private static final String FACTORY_METHOD = "factoryMethod";
    private static final String ACCESSOR_METHOD = "accessorMethod";
    private static final String ACCEPT_NULL = "acceptNull";
    private final AnnotationValue valueType;
    private final AnnotationValue factoryMethod;
    private final AnnotationValue accessorMethod;
    private final AnnotationValue acceptNull;

    DomainAnnot(AnnotationMirror annotationMirror, Map<String, AnnotationValue> values) {
        super(annotationMirror);
        this.valueType = AssertionUtil.assertNonNullValue(values, VALUE_TYPE);
        this.factoryMethod = AssertionUtil.assertNonNullValue(values, FACTORY_METHOD);
        this.accessorMethod = AssertionUtil.assertNonNullValue(values, ACCESSOR_METHOD);
        this.acceptNull = AssertionUtil.assertNonNullValue(values, ACCEPT_NULL);
    }

    public AnnotationValue getValueType() {
        return this.valueType;
    }

    public AnnotationValue getFactoryMethod() {
        return this.factoryMethod;
    }

    public AnnotationValue getAccessorMethod() {
        return this.accessorMethod;
    }

    public AnnotationValue getAcceptNull() {
        return this.acceptNull;
    }

    public TypeMirror getValueTypeValue() {
        TypeMirror value = AnnotationValueUtil.toType(this.valueType);
        if (value == null) {
            throw new AptIllegalStateException(VALUE_TYPE);
        }
        return value;
    }

    public String getFactoryMethodValue() {
        String value = AnnotationValueUtil.toString(this.factoryMethod);
        if (value == null) {
            throw new AptIllegalStateException(FACTORY_METHOD);
        }
        return value;
    }

    public String getAccessorMethodValue() {
        String value = AnnotationValueUtil.toString(this.accessorMethod);
        if (value == null) {
            throw new AptIllegalStateException(ACCESSOR_METHOD);
        }
        return value;
    }

    public boolean getAcceptNullValue() {
        Boolean value = AnnotationValueUtil.toBoolean(this.acceptNull);
        if (value == null) {
            throw new AptIllegalStateException(ACCEPT_NULL);
        }
        return value;
    }
}

