/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.annot;

import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.annot.AbstractAnnot;
import org.seasar.doma.internal.apt.util.AnnotationValueUtil;
import org.seasar.doma.internal.util.AssertionUtil;

public class TableAnnot
extends AbstractAnnot {
    private static final String CATALOG = "catalog";
    private static final String SCHEMA = "schema";
    private static final String NAME = "name";
    private static final String QUOTE = "quote";
    private final AnnotationValue catalog;
    private final AnnotationValue schema;
    private final AnnotationValue name;
    private final AnnotationValue quote;

    TableAnnot(AnnotationMirror annotationMirror, Map<String, AnnotationValue> values) {
        super(annotationMirror);
        this.catalog = AssertionUtil.assertNonNullValue(values, CATALOG);
        this.schema = AssertionUtil.assertNonNullValue(values, SCHEMA);
        this.name = AssertionUtil.assertNonNullValue(values, NAME);
        this.quote = AssertionUtil.assertNonNullValue(values, QUOTE);
    }

    public String getCatalogValue() {
        String value = AnnotationValueUtil.toString(this.catalog);
        if (value == null) {
            throw new AptIllegalStateException(CATALOG);
        }
        return value;
    }

    public String getSchemaValue() {
        String value = AnnotationValueUtil.toString(this.schema);
        if (value == null) {
            throw new AptIllegalStateException(SCHEMA);
        }
        return value;
    }

    public String getNameValue() {
        String value = AnnotationValueUtil.toString(this.name);
        if (value == null) {
            throw new AptIllegalStateException(NAME);
        }
        return value;
    }

    public boolean getQuoteValue() {
        Boolean value = AnnotationValueUtil.toBoolean(this.quote);
        if (value == null) {
            throw new AptIllegalStateException(QUOTE);
        }
        return value;
    }
}

